/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.ServerBaseDeployable;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerDeployableWithTempCredentials
extends ServerBaseDeployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);
    protected Credentials myCredentials;
    protected boolean isPassMemoryOnly;

    public ServerDeployableWithTempCredentials(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/ServerDeployableWithTempCredentials", "<init>"));
        }
        super(server);
        this.isPassMemoryOnly = true;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.myCredentials;
    }

    @Override
    public boolean isPassMemoryOnly() {
        return this.isPassMemoryOnly;
    }

    @Override
    public void setCredentials(Credentials credentials, boolean memoryOnly, boolean isApplyCredentialsToPasswordSafe, boolean notifyGlobalUpdate) {
        this.myCredentials = credentials;
        this.isPassMemoryOnly = memoryOnly;
        if (isApplyCredentialsToPasswordSafe) {
            CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(this.myServer, memoryOnly);
            PasswordSafe.getInstance().set(attributes, credentials);
        }
        if (notifyGlobalUpdate) {
            LOG.assertTrue(isApplyCredentialsToPasswordSafe);
            ApplicationManager.getApplication().invokeLater(() -> ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDeployableWithTempCredentials that = (ServerDeployableWithTempCredentials)o;
        if (!this.myServer.equals(that.myServer)) {
            return false;
        }
        if (this.myCredentials == null ? that.myCredentials != null : !this.myCredentials.equals((Object)that.myCredentials)) {
            return false;
        }
        return this.isPassMemoryOnly == that.isPassMemoryOnly;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + (this.myCredentials == null ? 0 : this.myCredentials.hashCode());
        result = result * 31 + (this.isPassMemoryOnly ? 0 : 1);
        return result;
    }

    @Override
    public String toString() {
        return "ServerBaseDeployable{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + ", passMemoryOnly=" + this.isPassMemoryOnly + '}';
    }
}

