/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishActionUtil {
    private PublishActionUtil() {
    }

    @Nullable
    public static WebServerConfig findDefaultServer(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        return PublishConfig.getInstance(project).findDefaultServer();
    }

    @Nullable
    public static Trinity<VirtualFile, WebServerConfig, DeploymentPathMapping> findMappingForSingleFile(AnActionEvent e, boolean needsDirectory, boolean ignoreExcludedPaths) {
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length != 1 || files[0] == null || needsDirectory != files[0].isDirectory()) {
            return null;
        }
        Project project = e.getProject();
        Pair<WebServerConfig, DeploymentPathMapping> pair = PublishActionUtil.findMappingFor(files[0], project, ignoreExcludedPaths);
        return pair == null ? null : Trinity.create((Object)files[0], (Object)pair.getFirst(), (Object)pair.getSecond());
    }

    @Nullable
    public static VirtualFile[] getVirtualFiles(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            VirtualFile file = files[i];
            if (!(file instanceof LightVirtualFile) || (file = ((LightVirtualFile)file).getOriginalFile()) == null) continue;
            files[i] = file;
        }
        return files;
    }

    @Nullable
    public static Pair<WebServerConfig, DeploymentPathMapping> findMappingFor(@Nullable VirtualFile file, @Nullable Project project, boolean ignoreExcludedPaths) {
        if (file == null || project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        WebServerConfig server = publishConfig.findDefaultServer();
        if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return null;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, server, ignoreExcludedPaths).getFirst();
        return mapping != null && !StringUtil.isEmpty((String)mapping.getDeployPath()) ? Pair.create((Object)server, (Object)mapping) : null;
    }

    @Nullable
    public static WebServerConfig.RemotePath findDeployPathFor(@NotNull VirtualFile file, @Nullable Project project, boolean ignoreExcludedPaths) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil", "findDeployPathFor"));
        }
        Pair<WebServerConfig, DeploymentPathMapping> mapping = PublishActionUtil.findMappingFor(file, project, ignoreExcludedPaths);
        return mapping != null ? ((DeploymentPathMapping)mapping.second).mapToDeployPath(file.getPath(), (Mappable)mapping.first) : null;
    }

    public static boolean checkMapping(PublishConfig publishConfig, WebServerConfig server, String path, boolean allowChild) {
        return publishConfig.getNearestMappingForLocal(path, false, true, false, (Mappable)server).getFirst() != null || allowChild && !((List)publishConfig.getChildMappingsForLocal(path, true, false, (Mappable)server).getFirst()).isEmpty();
    }

    public static TransferTask.ListBased.ResultWithErrors scanFiles(ExecutionContext context, Collection<VirtualFile> roots) throws FileSystemException {
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (VirtualFile root : roots) {
            FileObject source = DeploymentPathUtils.getLocalFile(root.getPath());
            DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processOutgoing(source, result, context);
            errors.addAll(e);
        }
        return new TransferTask.ListBased.ResultWithErrors(result, errors);
    }

    public static AsyncResult<Deployable> chooseServer(PublishConfig publishConfig, Collection<Deployable> servers, AnActionEvent event, String popupMessage) {
        final AsyncResult result = new AsyncResult();
        ArrayList<Deployable> sorted = new ArrayList<Deployable>(servers);
        Collections.sort(sorted, (o1, o2) -> {
            boolean isProjectLevel2;
            boolean isProjectLevel1 = o1.isProjectLevel();
            if (isProjectLevel1 != (isProjectLevel2 = o2.isProjectLevel())) {
                return isProjectLevel1 ? -1 : 1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        final String defaultServerId = (String)publishConfig.getDefaultServerIdAndName().first;
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new ChooseServerStep(sorted, popupMessage){

            public PopupStep onChosen(Deployable selectedValue, boolean finalChoice) {
                result.setDone((Object)selectedValue);
                return FINAL_CHOICE;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public void canceled() {
                result.setRejected();
            }
        }){

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer<Deployable>((ListPopupImpl)this){

                    protected void customizeComponent(JList<? extends Deployable> list, Deployable value, boolean isSelected) {
                        super.customizeComponent(list, (Object)value, isSelected);
                        if (value != null && Comparing.equal((String)value.getId(), (String)defaultServerId)) {
                            this.myTextLabel.setText("<html><b>" + this.myTextLabel.getText() + "</b></html>");
                        }
                    }
                };
            }
        };
        InputEvent inputEvent = event.getInputEvent();
        Project project = event.getProject();
        if (inputEvent instanceof KeyEvent || project == null) {
            popup.showInBestPositionFor(event.getDataContext());
        } else {
            popup.showInScreenCoordinates((Component)WindowManager.getInstance().getIdeFrame(project).getComponent(), MouseInfo.getPointerInfo().getLocation());
        }
        return result;
    }

    public static boolean canUploadToDefaultServer(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil", "canUploadToDefaultServer"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil", "canUploadToDefaultServer"));
        }
        PublishConfig config = PublishConfig.getInstance(project);
        WebServerConfig server = config.findDefaultServer();
        if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return false;
        }
        return config.getNearestMappingForLocal(file.getPath(), false, true, false, (Mappable)server).getFirst() != null;
    }

    public static AsyncResult<Void> uploadToDefaultServer(@NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil", "uploadToDefaultServer"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil", "uploadToDefaultServer"));
        }
        final AsyncResult result = new AsyncResult();
        PublishConfig config = PublishConfig.getInstance(project);
        WebServerConfig server = config.findDefaultServer();
        if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            result.setRejected();
            return result;
        }
        AutoUploadComponent.saveDocumentsSilently(project, Collections.singletonList(file));
        String title = WDBundle.message("upload.to", server.getName());
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, config.getTraceLevel());
        Deployable deployable = Deployable.create(server);
        new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, config, deployable, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

            @Override
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                return PublishActionUtil.scanFiles(context, Collections.singleton(file));
            }

            @Override
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil$3", "run"));
                }
                if (this.doRun(pi)) {
                    result.setDone(null);
                } else {
                    result.setRejected();
                }
            }
        }.queue();
        return result;
    }

    private static class ChooseServerStep
    extends BaseListPopupStep<Deployable> {
        public ChooseServerStep(List<Deployable> servers, String message) {
            super(message, servers);
        }

        public Icon getIconFor(Deployable aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(Deployable server) {
            String string = ChooseServerStep.numberingText(this.getValues().indexOf(server), server.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil$ChooseServerStep", "getTextFor"));
            }
            return string;
        }

        public boolean isMnemonicsNavigationEnabled() {
            return true;
        }

        private static String numberingText(int n, String text) {
            text = n < 9 ? "&" + (n + 1) + ". " + text : (n == 9 ? "&0. " + text : "&" + (char)(65 + n - 10) + ". " + text);
            return text;
        }
    }
}

