/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.util.containers.DistinctRootsCollection;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;

public abstract class DistinctRootsCollections {

    public static class RemotePaths
    extends DistinctRootsCollection<WebServerConfig.RemotePath> {
        private final boolean myCaseSensitive;

        public RemotePaths(boolean caseSensitive) {
            this.myCaseSensitive = caseSensitive;
        }

        public RemotePaths(Collection<WebServerConfig.RemotePath> collection, boolean caseSensitive) {
            super(collection);
            this.myCaseSensitive = caseSensitive;
        }

        public RemotePaths(WebServerConfig.RemotePath[] collection, boolean caseSensitive) {
            super((Object[])collection);
            this.myCaseSensitive = caseSensitive;
        }

        protected boolean isAncestor(@NotNull WebServerConfig.RemotePath ancestor, @NotNull WebServerConfig.RemotePath path) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$RemotePaths", "isAncestor"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$RemotePaths", "isAncestor"));
            }
            return DeploymentPathUtils.isAncestor(ancestor.path, path.path, this.myCaseSensitive);
        }
    }

    public static class ServerTreeNodes
    extends DistinctRootsCollection<ServerTreeNode> {
        private final boolean myCaseSensistive;

        public ServerTreeNodes(ServerTreeNode[] nodes, boolean caseSensistive) {
            super(Arrays.asList(nodes));
            this.myCaseSensistive = caseSensistive;
        }

        protected boolean isAncestor(@NotNull ServerTreeNode ancestor, @NotNull ServerTreeNode node) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$ServerTreeNodes", "isAncestor"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$ServerTreeNodes", "isAncestor"));
            }
            return DeploymentPathUtils.isAncestor(ancestor.getPath().path, node.getPath().path, this.myCaseSensistive);
        }
    }

    public static class SystemIndependentPaths
    extends DistinctRootsCollection<String> {
        private final boolean myCaseSensitive;

        public SystemIndependentPaths(boolean caseSensitive) {
            this.myCaseSensitive = caseSensitive;
        }

        public SystemIndependentPaths(Collection<String> collection, boolean caseSensitive) {
            super(collection);
            this.myCaseSensitive = caseSensitive;
        }

        public SystemIndependentPaths(String[] collection, boolean caseSensitive) {
            super((Object[])collection);
            this.myCaseSensitive = caseSensitive;
        }

        protected boolean isAncestor(@NotNull String ancestor, @NotNull String path) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$SystemIndependentPaths", "isAncestor"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$SystemIndependentPaths", "isAncestor"));
            }
            return DeploymentPathUtils.isAncestor(ancestor, path, this.myCaseSensitive);
        }
    }

    public static class FileObjects
    extends DistinctRootsCollection<FileObject> {
        public FileObjects() {
        }

        public FileObjects(Collection<FileObject> fileObjects) {
            super(fileObjects);
        }

        public FileObjects(FileObject[] collection) {
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull FileObject ancestor, @NotNull FileObject fileObject) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$FileObjects", "isAncestor"));
            }
            if (fileObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/DistinctRootsCollections$FileObjects", "isAncestor"));
            }
            return ancestor.getName().isAncestor(fileObject.getName());
        }
    }
}

