/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.jee.EarFacetImporter;
import org.jetbrains.idea.maven.importing.ManifestImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;

public class EarManifestImporter
extends ManifestImporter {
    private final EarFacetImporter myEarFacetImporter;

    public EarManifestImporter(EarFacetImporter earFacetImporter) {
        this.myEarFacetImporter = earFacetImporter;
    }

    protected boolean isApplicable(String packaging) {
        return "ear".equalsIgnoreCase(packaging);
    }

    protected String doGetClasspathItem(@NotNull MavenProject mavenProject, @NotNull MavenArtifact mavenArtifact, @NotNull String artifactFileName) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/ext/jee/EarManifestImporter", "doGetClasspathItem"));
        }
        if (mavenArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenArtifact", "org/jetbrains/idea/maven/ext/jee/EarManifestImporter", "doGetClasspathItem"));
        }
        if (artifactFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactFileName", "org/jetbrains/idea/maven/ext/jee/EarManifestImporter", "doGetClasspathItem"));
        }
        final String[] classpathItem = new String[2];
        this.myEarFacetImporter.link(mavenProject, mavenArtifact, artifactFileName, true, new EarFacetImporter.Linker(){

            @Override
            public void link(@Nullable String dir, @NotNull String artifactName, Element configElement) {
                if (artifactName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/idea/maven/ext/jee/EarManifestImporter$1", "link"));
                }
                classpathItem[0] = dir;
                classpathItem[1] = artifactName;
            }
        });
        return (!StringUtil.isEmpty((String)classpathItem[0]) && !"/".equals(classpathItem[0]) ? classpathItem[0] + "/" : "") + classpathItem[1];
    }
}

