/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.compatibility;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAP11BuilderHelper;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAP12BuilderHelper;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomSOAPBuilderHelper;

public class CustomStAXSOAPModelBuilder
extends StAXOMBuilder {
    SOAPMessage soapMessage;
    private SOAPEnvelope envelope;
    private OMNamespace envelopeNamespace;
    private String namespaceURI;
    private SOAPFactory soapFactory;
    private boolean headerPresent = false;
    private boolean bodyPresent = false;
    private static final Log log = LogFactory.getLog(CustomStAXSOAPModelBuilder.class);
    private boolean processingFault = false;
    private boolean processingDetailElements = false;
    private CustomSOAPBuilderHelper builderHelper;
    private String parserVersion = null;
    private static final boolean isDebugEnabled = log.isDebugEnabled();

    public CustomStAXSOAPModelBuilder(XMLStreamReader parser, String soapVersion) {
        super(parser);
        this.parserVersion = parser.getVersion();
        this.identifySOAPVersion(soapVersion);
    }

    public CustomStAXSOAPModelBuilder(XMLStreamReader parser) {
        super(parser);
        this.parserVersion = parser.getVersion();
        SOAPEnvelope soapEnvelope = this.getSOAPEnvelope();
        this.envelopeNamespace = soapEnvelope.getNamespace();
    }

    public CustomStAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, String soapVersion) {
        super((OMFactory)factory, parser);
        this.soapFactory = factory;
        this.parserVersion = parser.getVersion();
        this.identifySOAPVersion(soapVersion);
    }

    protected void identifySOAPVersion(String soapVersionURIFromTransport) {
        String namespaceName;
        SOAPEnvelope soapEnvelope = this.getSOAPEnvelope();
        if (soapEnvelope == null) {
            throw new SOAPProcessingException("SOAP Message does not contain an Envelope", "VersionMismatch");
        }
        this.envelopeNamespace = soapEnvelope.getNamespace();
        if (soapVersionURIFromTransport != null && !soapVersionURIFromTransport.equals(namespaceName = this.envelopeNamespace.getNamespaceURI())) {
            throw new SOAPProcessingException("Transport level information does not match with SOAP Message namespace URI", this.envelopeNamespace.getPrefix() + ":" + "VersionMismatch");
        }
    }

    public SOAPEnvelope getSOAPEnvelope() throws OMException {
        while (this.envelope == null && !this.done) {
            this.next();
        }
        return this.envelope;
    }

    protected OMNode createNextOMElement() {
        String localPart;
        String namespace;
        CustomBuilder customBuilder;
        OMNode newElement = null;
        if (this.elementLevel == 3 && this.customBuilderForPayload != null) {
            OMNode parent = this.lastNode;
            if (parent != null && parent.isComplete()) {
                parent = (OMNode)this.lastNode.getParent();
            }
            if (parent instanceof SOAPBody) {
                newElement = this.createWithCustomBuilder(this.customBuilderForPayload, (OMFactory)this.soapFactory);
            }
        }
        if (newElement == null && this.customBuilders != null && this.elementLevel <= this.maxDepthForCustomBuilders && (customBuilder = this.getCustomBuilder(namespace = this.parser.getNamespaceURI(), localPart = this.parser.getLocalName())) != null) {
            newElement = this.createWithCustomBuilder(customBuilder, (OMFactory)this.soapFactory);
        }
        if (newElement == null) {
            newElement = this.createOMElement();
        } else {
            --this.elementLevel;
        }
        return newElement;
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.constructNode(null, elementName, true);
            this.setSOAPEnvelope(node);
        } else if (this.lastNode.isComplete()) {
            OMContainer parent = this.lastNode.getParent();
            if (parent == this.document) {
                this.lastNode = null;
                node = this.constructNode(null, elementName, true);
                this.setSOAPEnvelope(node);
            } else {
                node = this.constructNode((OMElement)parent, elementName, false);
                ((OMNodeEx)this.lastNode).setNextOMSibling((OMNode)node);
                ((OMNodeEx)node).setPreviousOMSibling(this.lastNode);
            }
        } else {
            OMContainerEx e = (OMContainerEx)this.lastNode;
            node = this.constructNode((OMElement)this.lastNode, elementName, false);
            e.setFirstChild((OMNode)node);
        }
        if (isDebugEnabled) {
            log.debug((Object)("Build the OMElement " + node.getLocalName() + " by the StaxSOAPModelBuilder"));
        }
        return node;
    }

    protected void setSOAPEnvelope(OMElement node) {
        this.soapMessage.setSOAPEnvelope((SOAPEnvelope)node);
        this.soapMessage.setXMLVersion(this.parserVersion);
        this.soapMessage.setCharsetEncoding(this.charEncoding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OMElement constructNode(OMElement parent, String elementName, boolean isEnvelope) {
        SOAPHeaderBlock element;
        if (parent == null) {
            if (!elementName.equals("Envelope")) {
                throw new SOAPProcessingException("First Element must contain the local name, Envelope , but found " + elementName, "");
            }
            if (this.soapFactory == null) {
                this.namespaceURI = this.parser.getNamespaceURI();
                if ("http://www.w3.org/2003/05/soap-envelope".equals(this.namespaceURI)) {
                    this.soapFactory = OMAbstractFactory.getSOAP12Factory();
                    if (isDebugEnabled) {
                        log.debug((Object)"Starting to process SOAP 1.2 message");
                    }
                } else {
                    if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(this.namespaceURI)) throw new SOAPProcessingException("Only SOAP 1.1 or SOAP 1.2 messages are supported in the system", "VersionMismatch");
                    this.soapFactory = OMAbstractFactory.getSOAP11Factory();
                    if (isDebugEnabled) {
                        log.debug((Object)"Starting to process SOAP 1.1 message");
                    }
                }
            } else {
                this.namespaceURI = this.soapFactory.getSoapVersionURI();
            }
            this.soapMessage = this.soapFactory.createSOAPMessage((OMXMLParserWrapper)this);
            this.document = this.soapMessage;
            if (this.charEncoding != null) {
                this.document.setCharsetEncoding(this.charEncoding);
            }
            this.envelope = this.soapFactory.createSOAPEnvelope((OMXMLParserWrapper)this);
            element = this.envelope;
            this.processNamespaceData((OMElement)element, true);
            this.processAttributes((OMElement)element);
            return element;
        }
        if (this.elementLevel == 2) {
            String elementNS = this.parser.getNamespaceURI();
            if (!this.namespaceURI.equals(elementNS)) {
                if (!this.bodyPresent) throw new SOAPProcessingException("Disallowed element found inside Envelope : {" + elementNS + "}" + elementName);
                if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(this.namespaceURI)) {
                    throw new SOAPProcessingException("Disallowed element found inside Envelope : {" + elementNS + "}" + elementName);
                }
            }
            if (elementName.equals("Header")) {
                if (this.headerPresent) {
                    throw new SOAPProcessingException("Multiple headers encountered!", this.getSenderFaultCode());
                }
                if (this.bodyPresent) {
                    throw new SOAPProcessingException("Header Body wrong order!", this.getSenderFaultCode());
                }
                this.headerPresent = true;
                element = this.soapFactory.createSOAPHeader((SOAPEnvelope)parent, (OMXMLParserWrapper)this);
                this.processNamespaceData((OMElement)element, true);
                this.processAttributes((OMElement)element);
                return element;
            } else {
                if (!elementName.equals("Body")) throw new SOAPProcessingException(elementName + " is not supported here. Envelope can not have elements other than Header and Body.", this.getSenderFaultCode());
                if (this.bodyPresent) {
                    throw new SOAPProcessingException("Multiple body elements encountered", this.getSenderFaultCode());
                }
                this.bodyPresent = true;
                element = this.soapFactory.createSOAPBody((SOAPEnvelope)parent, (OMXMLParserWrapper)this);
                this.processNamespaceData((OMElement)element, true);
                this.processAttributes((OMElement)element);
            }
            return element;
        }
        if (this.elementLevel == 3 && parent.getLocalName().equals("Header")) {
            try {
                element = this.soapFactory.createSOAPHeaderBlock(elementName, null, (SOAPHeader)parent, (OMXMLParserWrapper)this);
            }
            catch (SOAPProcessingException e) {
                throw new SOAPProcessingException("Can not create SOAPHeader block", this.getReceiverFaultCode(), (Throwable)e);
            }
            this.processNamespaceData((OMElement)element, false);
            this.processAttributes((OMElement)element);
            return element;
        }
        if (this.elementLevel == 3 && parent.getLocalName().equals("Body") && elementName.equals("Fault")) {
            element = this.soapFactory.createSOAPFault((SOAPBody)parent, (OMXMLParserWrapper)this);
            this.processNamespaceData((OMElement)element, false);
            this.processAttributes((OMElement)element);
            this.processingFault = true;
            if ("http://www.w3.org/2003/05/soap-envelope".equals(this.envelopeNamespace.getNamespaceURI())) {
                this.builderHelper = new CustomSOAP12BuilderHelper(this);
                return element;
            } else {
                if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(this.envelopeNamespace.getNamespaceURI())) return element;
                this.builderHelper = new CustomSOAP11BuilderHelper(this);
            }
            return element;
        } else {
            if (this.elementLevel > 3 && this.processingFault) {
                return this.builderHelper.handleEvent(this.parser, parent, this.elementLevel);
            }
            element = this.soapFactory.createOMElement(elementName, null, (OMContainer)parent, (OMXMLParserWrapper)this);
            this.processNamespaceData((OMElement)element, false);
            this.processAttributes((OMElement)element);
        }
        return element;
    }

    private String getSenderFaultCode() {
        return this.envelope.getVersion().getSenderFaultCode().getLocalPart();
    }

    private String getReceiverFaultCode() {
        return this.envelope.getVersion().getReceiverFaultCode().getLocalPart();
    }

    public void endElement() {
        if (this.lastNode.isComplete()) {
            OMElement parent = (OMElement)this.lastNode.getParent();
            ((OMNodeEx)parent).setComplete(true);
            this.lastNode = parent;
        } else {
            OMNode e = this.lastNode;
            ((OMNodeEx)e).setComplete(true);
        }
    }

    protected OMNode createDTD() throws OMException {
        throw new OMException("SOAP message MUST NOT contain a Document Type Declaration(DTD)");
    }

    protected OMNode createPI() throws OMException {
        throw new OMException("SOAP message MUST NOT contain Processing Instructions(PI)");
    }

    public OMElement getDocumentElement() {
        return this.envelope != null ? this.envelope : this.getSOAPEnvelope();
    }

    protected void processNamespaceData(OMElement node, boolean isSOAPElement) {
        super.processNamespaceData(node);
        if (isSOAPElement && node.getNamespace() != null && !node.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new SOAPProcessingException("invalid SOAP namespace URI. Only http://schemas.xmlsoap.org/soap/envelope/ and http://www.w3.org/2003/05/soap-envelope are supported.", "Sender");
        }
    }

    public OMNamespace getEnvelopeNamespace() {
        return this.envelopeNamespace;
    }

    public boolean isProcessingDetailElements() {
        return this.processingDetailElements;
    }

    public void setProcessingDetailElements(boolean value) {
        this.processingDetailElements = value;
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    public OMDocument getDocument() {
        return this.soapMessage;
    }

    protected SOAPFactory getSoapFactory() {
        return this.soapFactory;
    }

    void adjustElementLevel(int value) {
        this.elementLevel += value;
    }
}

