/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.auth;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.webservice.WebServiceHelper;
import org.jetbrains.tfsIntegration.webservice.auth.NTLM2Scheme;

public class NativeNTLM2Scheme
extends NTLM2Scheme {
    private static final Logger LOG = Logger.getInstance((String)NativeNTLM2Scheme.class.getName());
    @Nullable
    private final Object myAuthSequenceObject;
    @Nullable
    private final Method myGetAuthHeaderMethod;

    public NativeNTLM2Scheme() {
        Pair<Object, Method> pair = NativeNTLM2Scheme.createNativeAuthSequence();
        this.myAuthSequenceObject = pair != null ? pair.first : null;
        this.myGetAuthHeaderMethod = pair != null ? (Method)pair.second : null;
    }

    @Nullable
    private static Pair<Object, Method> createNativeAuthSequence() {
        boolean java7 = SystemInfo.isJavaVersionAtLeast((String)"1.7");
        try {
            Class<?> clazz;
            Class<?> clazz2 = clazz = java7 ? Class.forName("sun.net.www.protocol.http.ntlm.NTLMAuthSequence") : Class.forName("sun.net.www.protocol.http.NTLMAuthSequence");
            if (clazz == null) {
                return null;
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, String.class);
            constructor.setAccessible(true);
            Object sequence = constructor.newInstance(null, null, null);
            Method method = clazz.getMethod("getAuthHeader", String.class);
            if (method == null) {
                return null;
            }
            return Pair.create(sequence, (Object)method);
        }
        catch (Throwable t) {
            LOG.debug(t);
            return null;
        }
    }

    @Override
    protected String getType1MessageResponse(NTCredentials ntcredentials, HttpMethodParams params) {
        if (!params.getBooleanParameter(WebServiceHelper.USE_NATIVE_CREDENTIALS, false) || this.myAuthSequenceObject == null) {
            return super.getType1MessageResponse(ntcredentials, params);
        }
        try {
            return (String)this.myGetAuthHeaderMethod.invoke(this.myAuthSequenceObject, new Object[]{null});
        }
        catch (Throwable t) {
            LOG.warn("Native authentication failed", t);
            return "";
        }
    }

    @Override
    protected String getType3MessageResponse(String type2message, NTCredentials ntcredentials, HttpMethodParams params) throws AuthenticationException {
        if (!params.getBooleanParameter(WebServiceHelper.USE_NATIVE_CREDENTIALS, false) || this.myAuthSequenceObject == null) {
            return super.getType3MessageResponse(type2message, ntcredentials, params);
        }
        try {
            return (String)this.myGetAuthHeaderMethod.invoke(this.myAuthSequenceObject, type2message);
        }
        catch (Throwable t) {
            LOG.warn("Native authentication failed", t);
            return "";
        }
    }

    public static boolean isAvailable() {
        return NativeNTLM2Scheme.createNativeAuthSequence() != null;
    }
}

