/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class LocalAndServerPathsForm
implements Disposable {
    private TextFieldWithBrowseButton myLocalPathField;
    private JPanel myContentPanel;
    private JLabel myMessageLabel;
    private TfsTreeForm myServerPathForm;
    private JLabel myServerPathLabel;
    private JLabel myLocalPathLabel;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public LocalAndServerPathsForm() {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)this, (Disposable)this.myServerPathForm);
        this.myServerPathForm.addListener(new TfsTreeForm.SelectionListener(){

            @Override
            public void selectionChanged() {
                ((ChangeListener)LocalAndServerPathsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myLocalPathLabel.setLabelFor(this.myLocalPathField.getChildComponent());
        ((JTextField)this.myLocalPathField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)LocalAndServerPathsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener listener = new ComponentWithBrowseButton.BrowseFolderActionListener(TFSBundle.message("choose.local.path.title", new Object[0]), TFSBundle.message("choose.local.path.description", new Object[0]), (ComponentWithBrowseButton)this.myLocalPathField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myServerPathLabel.setLabelFor(this.myServerPathForm.getPreferredFocusedComponent());
        this.myLocalPathField.addActionListener((ActionListener)listener);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
    }

    public void initialize(ServerInfo server, String initialPath) {
        this.myServerPathForm.initialize(server, initialPath, true, false, null);
    }

    public String getLocalPath() {
        return this.myLocalPathField.getText();
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    @Nullable
    public String getServerPath() {
        return this.myServerPathForm.getSelectedPath();
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void setMessage(String text, boolean error) {
        if (text != null) {
            this.myMessageLabel.setVisible(true);
            this.myMessageLabel.setText(text);
            this.myMessageLabel.setIcon(error ? UIUtil.getBalloonWarningIcon() : TfsTreeForm.EMPTY_ICON);
        } else {
            this.myMessageLabel.setVisible(false);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myServerPathForm.getPreferredFocusedComponent();
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TfsTreeForm tfsTreeForm;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerPathLabel = jLabel3 = new JLabel();
        jLabel3.setText("Source path:");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalPathLabel = jLabel2 = new JLabel();
        jLabel2.setText("Destination path:");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerPathForm = tfsTreeForm = new TfsTreeForm();
        JComponent jComponent = tfsTreeForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.myLocalPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

