/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CheckoutModeForm {
    private JPanel myContentPanel;
    private JRadioButton myAutoModeButton;
    private JRadioButton myManualModeButton;
    private JTextField myWorkspaceNameField;
    private JLabel myErrorLabel;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CheckoutModeForm() {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myAutoModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ChangeListener)CheckoutModeForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
                IdeFocusManager.findInstanceByComponent((Component)CheckoutModeForm.this.myContentPanel).requestFocus((Component)CheckoutModeForm.this.myWorkspaceNameField, true);
            }
        });
        this.myManualModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ChangeListener)CheckoutModeForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myWorkspaceNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CheckoutModeForm.this.myAutoModeButton.setSelected(true);
                ((ChangeListener)CheckoutModeForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        });
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public boolean isAutoModeSelected() {
        return this.myAutoModeButton.isSelected();
    }

    public void setAutoModeSelected(boolean selected) {
        if (selected) {
            this.myAutoModeButton.setSelected(true);
        } else {
            this.myManualModeButton.setSelected(true);
        }
    }

    public String getNewWorkspaceName() {
        return this.myWorkspaceNameField.getText();
    }

    public void setNewWorkspaceName(String name) {
        this.myWorkspaceNameField.setText(name);
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void setErrorMessage(String message) {
        this.myErrorLabel.setText(message);
        this.myErrorLabel.setVisible(message != null);
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myAutoModeButton.isSelected()) {
            return this.myWorkspaceNameField;
        }
        return this.myManualModeButton;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JTextField jTextField;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myManualModeButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(false);
        jRadioButton2.setText("Choose workspace manually");
        jRadioButton2.setMnemonic('M');
        jRadioButton2.setDisplayedMnemonicIndex(17);
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0), null, 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Workspace name:");
        jLabel2.setDisplayedMnemonic('W');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkspaceNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 10, 1, 2, 0, null, new Dimension(458, 20), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>On import new workspace will be created automatically with a given name.<br>Workspace will contain the appropriate working folder mapping<br>to match your choice of server and local paths.");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("<html>Existing workspace will be used for import.<br>Available server paths will depend on the working folder mappings for selected workspace.");
        jPanel3.add((Component)jLabel4, "Center");
        this.myAutoModeButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("Create workspace automatically");
        jRadioButton.setMnemonic('A');
        jRadioButton.setDisplayedMnemonicIndex(17);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

