/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.StandardVersionFilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class TFSVersionFilterComponent
extends StandardVersionFilterComponent<ChangeBrowserSettings> {
    private JPanel myPanel;
    private JCheckBox myUseAuthorFilter;
    private JTextField myAuthorField;
    private JPanel myStandardPanel;

    public TFSVersionFilterComponent(boolean showDateFilter) {
        super(showDateFilter);
        this.$$$setupUI$$$();
        this.myStandardPanel.setLayout(new BorderLayout());
        this.myStandardPanel.add(this.getStandardPanel(), "Center");
        this.init(new ChangeBrowserSettings());
    }

    protected void updateAllEnabled(ActionEvent e) {
        super.updateAllEnabled(e);
        TFSVersionFilterComponent.updatePair((JCheckBox)this.myUseAuthorFilter, (JComponent)this.myAuthorField, (ActionEvent)e);
    }

    protected void initValues(ChangeBrowserSettings settings) {
        super.initValues(settings);
        this.myUseAuthorFilter.setSelected(settings.USE_USER_FILTER);
        this.myAuthorField.setText(settings.USER);
    }

    public void saveValues(ChangeBrowserSettings settings) {
        super.saveValues(settings);
        settings.USER = this.myAuthorField.getText();
        settings.USE_USER_FILTER = this.myUseAuthorFilter.isSelected();
    }

    protected void installCheckBoxListener(ActionListener filterListener) {
        super.installCheckBoxListener(filterListener);
        this.myUseAuthorFilter.addActionListener(filterListener);
        this.myAuthorField.addActionListener(filterListener);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    public String getAuthorFilter() {
        if (this.myUseAuthorFilter.isSelected() && this.myAuthorField.getText().length() > 0) {
            return this.myAuthorField.getText();
        }
        return null;
    }

    protected String getChangeNumberTitle() {
        return "Revision";
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseAuthorFilter = jCheckBox = new JCheckBox();
        jCheckBox.setText("Author");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAuthorField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStandardPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

