/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionControlLabel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.ui.SelectLabelForm;

public class SelectLabelDialog
extends DialogWrapper {
    private final WorkspaceInfo myWorkspace;
    private SelectLabelForm mySelectLabelForm;

    public SelectLabelDialog(Project project, WorkspaceInfo workspace) {
        super(project, true);
        this.myWorkspace = workspace;
        this.setTitle("Choose Label");
        this.setOKButtonText("Choose");
        this.init();
        this.updateButtons();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.mySelectLabelForm = new SelectLabelForm(this, this.myWorkspace);
        this.mySelectLabelForm.addListener(new SelectLabelForm.Listener(){

            @Override
            public void selectionChanged() {
                SelectLabelDialog.this.updateButtons();
            }
        });
        return this.mySelectLabelForm.getContentPane();
    }

    private void updateButtons() {
        this.setOKActionEnabled(this.mySelectLabelForm.isLabelSelected());
    }

    @NotNull
    public String getLabelString() {
        VersionControlLabel label = this.mySelectLabelForm.getLabel();
        String string = label.getName() + "@" + label.getScope();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SelectLabelDialog", "getLabelString"));
        }
        return string;
    }

    protected String getDimensionServiceKey() {
        return "TFS.SelectLabel";
    }
}

