/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ResolveConflictHelper;
import org.jetbrains.tfsIntegration.ui.ResolveConflictsForm;

public class ResolveConflictsDialog
extends DialogWrapper {
    private final ResolveConflictHelper myResolveConflictHelper;

    public ResolveConflictsDialog(ResolveConflictHelper resolveConflictHelper) {
        super(true);
        this.myResolveConflictHelper = resolveConflictHelper;
        this.setTitle("Resolve Conflicts");
        this.setResizable(true);
        this.setOKButtonText("Close");
        this.init();
    }

    protected void doOKAction() {
        for (Conflict conflict : this.myResolveConflictHelper.getConflicts()) {
            this.myResolveConflictHelper.skip(conflict);
        }
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ResolveConflictsForm resolveConflictsForm = new ResolveConflictsForm(this.myResolveConflictHelper);
        resolveConflictsForm.addListener(new ResolveConflictsForm.Listener(){

            @Override
            public void close() {
                ResolveConflictsDialog.this.close(0);
            }
        });
        return resolveConflictsForm.getPanel();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/ResolveConflictsDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return "TFS.ResolveConflicts";
    }
}

