/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.BranchRelative;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.MergeCandidate;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;
import org.jetbrains.tfsIntegration.ui.ChangesetsTableModel;
import org.jetbrains.tfsIntegration.ui.SelectRevisionForm;
import org.jetbrains.tfsIntegration.ui.servertree.ServerBrowserDialog;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class MergeBranchForm {
    private TextFieldWithBrowseButton.NoPathCompletion mySourceField;
    private JComboBox myTargetCombo;
    private JComboBox myChangesTypeCombo;
    private final SelectRevisionForm mySelectRevisionForm;
    private JPanel myContentPanel;
    private JPanel myChangesetsPanel;
    private JLabel mySourceBranchLabel;
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private final JTable myChangesetsTable;
    private final ChangesetsTableModel myChangesetsTableModel;
    private final String myDialogTitle;
    private final EventDispatcher<Listener> myEventDispatcher;
    private boolean mySourceIsDirectory;
    private final FocusListener mySourceFieldFocusListener;

    public MergeBranchForm(final Project project, final WorkspaceInfo workspace, String initialSourcePath, boolean initialSourcePathIsDirectory, String dialogTitle) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.myDialogTitle = dialogTitle;
        this.mySourceBranchLabel.setLabelFor(this.mySourceField.getChildComponent());
        this.myChangesetsTableModel = new ChangesetsTableModel();
        this.myChangesetsTable = new JBTable((TableModel)this.myChangesetsTableModel);
        this.myChangesetsTable.setSelectionMode(1);
        for (int i = 0; i < ChangesetsTableModel.Column.values().length; ++i) {
            this.myChangesetsTable.getColumnModel().getColumn(i).setPreferredWidth(ChangesetsTableModel.Column.values()[i].getWidth());
        }
        this.mySelectRevisionForm = new SelectRevisionForm();
        this.myChangesetsPanel.add((Component)this.mySelectRevisionForm.getPanel(), ChangesType.ALL.toString());
        this.myChangesetsPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myChangesetsTable), ChangesType.SELECTED.toString());
        this.mySourceField.setText(initialSourcePath);
        this.mySourceIsDirectory = initialSourcePathIsDirectory;
        this.mySourceField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerBrowserDialog d = new ServerBrowserDialog(TFSBundle.message("choose.source.item.dialog.title", new Object[0]), project, workspace.getServer(), MergeBranchForm.this.mySourceField.getText(), false, false);
                if (d.showAndGet()) {
                    TfsTreeForm.SelectedItem selectedItem = d.getSelectedItem();
                    MergeBranchForm.this.mySourceField.setText(selectedItem != null ? selectedItem.path : null);
                    MergeBranchForm.this.mySourceIsDirectory = selectedItem == null || selectedItem.isDirectory;
                }
                MergeBranchForm.this.updateOnSourceChange();
            }
        });
        this.mySourceFieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MergeBranchForm.this.mySourceIsDirectory = true;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MergeBranchForm.this.updateOnSourceChange();
                    }
                }, ModalityState.current());
            }
        };
        this.mySourceField.getTextField().addFocusListener(this.mySourceFieldFocusListener);
        this.myTargetCombo.setModel(new DefaultComboBoxModel());
        this.myTargetCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Item item = (Item)value;
                    this.setText(item.getItem());
                }
                return c;
            }
        });
        this.myTargetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergeBranchForm.this.myChangesTypeCombo.getSelectedItem() == ChangesType.SELECTED) {
                    MergeBranchForm.this.updateChangesetsTable();
                }
            }
        });
        this.myChangesTypeCombo.setModel(new DefaultComboBoxModel<ChangesType>(ChangesType.values()));
        this.myChangesTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergeBranchForm.this.myChangesTypeCombo.getSelectedItem() == ChangesType.SELECTED) {
                    MergeBranchForm.this.updateChangesetsTable();
                }
                ((CardLayout)MergeBranchForm.this.myChangesetsPanel.getLayout()).show(MergeBranchForm.this.myChangesetsPanel, MergeBranchForm.this.myChangesTypeCombo.getSelectedItem().toString());
                MergeBranchForm.this.fireStateChanged();
            }
        });
        this.myChangesetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MergeBranchForm.this.fireStateChanged();
            }
        });
        this.myChangesTypeCombo.setSelectedIndex(0);
        this.mySelectRevisionForm.init(project, workspace, initialSourcePath, initialSourcePathIsDirectory);
    }

    public JComponent getContentPanel() {
        return this.myContentPanel;
    }

    private void updateChangesetsTable() {
        ArrayList<Changeset> changesets = new ArrayList<Changeset>();
        if (this.myTargetCombo.getSelectedIndex() != -1) {
            try {
                Collection<MergeCandidate> mergeCandidates = this.myWorkspace.getServer().getVCS().queryMergeCandidates(this.myWorkspace.getName(), this.myWorkspace.getOwnerName(), this.mySourceField.getText(), this.getTargetPath(), this.myProject, TFSBundle.message("loading.branches", new Object[0]));
                for (MergeCandidate candidate : mergeCandidates) {
                    changesets.add(candidate.getChangeset());
                }
            }
            catch (TfsException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myDialogTitle);
            }
        }
        this.myChangesetsTableModel.setChangesets(changesets);
    }

    public String getSourcePath() {
        return this.mySourceField.getText();
    }

    public String getTargetPath() {
        Item targetBranch = (Item)this.myTargetCombo.getSelectedItem();
        return targetBranch.getItem();
    }

    @Nullable
    public VersionSpecBase getFromVersion() {
        ChangesType changesType = (ChangesType)((Object)this.myChangesTypeCombo.getSelectedItem());
        if (changesType == ChangesType.SELECTED) {
            Changeset fromChangeset = this.myChangesetsTableModel.getChangesets().get(this.myChangesetsTable.getSelectionModel().getMinSelectionIndex());
            return new ChangesetVersionSpec(fromChangeset.getCset());
        }
        return null;
    }

    @Nullable
    public VersionSpecBase getToVersion() {
        ChangesType changesType = (ChangesType)((Object)this.myChangesTypeCombo.getSelectedItem());
        if (changesType == ChangesType.SELECTED) {
            Changeset toChangeset = this.myChangesetsTableModel.getChangesets().get(this.myChangesetsTable.getSelectionModel().getMaxSelectionIndex());
            return new ChangesetVersionSpec(toChangeset.getCset());
        }
        return this.mySelectRevisionForm.getVersionSpec();
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private void fireStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).stateChanged(this.canFinish());
    }

    private boolean canFinish() {
        ChangesType changesType = (ChangesType)((Object)this.myChangesTypeCombo.getSelectedItem());
        if (changesType == ChangesType.SELECTED && this.myChangesetsTable.getSelectedRowCount() == 0) {
            return false;
        }
        return this.myTargetCombo.getSelectedIndex() != -1;
    }

    private void updateOnSourceChange() {
        ArrayList<Item> targetBranches = new ArrayList<Item>();
        try {
            Collection<BranchRelative> allBranches = this.myWorkspace.getServer().getVCS().queryBranches(this.mySourceField.getText(), LatestVersionSpec.INSTANCE, this.myProject, TFSBundle.message("loading.branches", new Object[0]));
            BranchRelative subject = null;
            for (BranchRelative branch : allBranches) {
                if (!branch.getReqstd()) continue;
                subject = branch;
                break;
            }
            for (BranchRelative branch : allBranches) {
                if (branch.getRelfromid() != subject.getReltoid() && branch.getReltoid() != subject.getRelfromid() || branch.getBranchToItem().getDid() != Integer.MIN_VALUE) continue;
                targetBranches.add(branch.getBranchToItem());
            }
        }
        catch (UserCancelledException e) {
            return;
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myDialogTitle);
        }
        ((DefaultComboBoxModel)this.myTargetCombo.getModel()).removeAllElements();
        for (Item targetBranch : targetBranches) {
            ((DefaultComboBoxModel)this.myTargetCombo.getModel()).addElement(targetBranch);
        }
        this.mySelectRevisionForm.init(this.myProject, this.myWorkspace, this.mySourceField.getText(), this.mySourceIsDirectory);
        this.fireStateChanged();
    }

    public void close() {
        this.mySourceField.getTextField().removeFocusListener(this.mySourceFieldFocusListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySourceField.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JLabel jLabel;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourceBranchLabel = jLabel = new JLabel();
        jLabel.setText("Source:");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel2.add((Component)noPathCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Target:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetCombo = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Changes to merge:", (int)0, (int)0, null, null));
        this.myChangesTypeCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myChangesetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static enum ChangesType {
        ALL{

            public String toString() {
                return "All changes up to a specific version";
            }
        }
        ,
        SELECTED{

            public String toString() {
                return "Selected changesets";
            }
        };

    }

    public static interface Listener
    extends EventListener {
        public void stateChanged(boolean var1);
    }
}

