/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class FieldWithButtonCellEditor<T>
extends DefaultCellEditor {
    public FieldWithButtonCellEditor(boolean pathCompletion, final Helper<T> helper) {
        super(new JTextField());
        this.setClickCountToStart(1);
        final TextFieldWithBrowseButton field = pathCompletion ? new TextFieldWithBrowseButton() : new TextFieldWithBrowseButton.NoPathCompletion();
        field.setOpaque(false);
        field.getTextField().setBorder(BorderFactory.createEmptyBorder());
        field.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String result = helper.processButtonClick(field.getText());
                if (result != null) {
                    field.setText(result);
                }
            }
        });
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                field.setText(helper.toStringRepresentation(value));
            }

            @Override
            @Nullable
            public Object getCellEditorValue() {
                return helper.fromStringRepresentation(field.getText());
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
        this.editorComponent = field;
    }

    public static interface Helper<T> {
        public String toStringRepresentation(@Nullable T var1);

        @Nullable
        public T fromStringRepresentation(@Nullable String var1);

        public String processButtonClick(String var1);
    }
}

