/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ConflictType;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;

public class ConflictsTableModel
extends AbstractTableModel {
    private List<Conflict> myConflicts;

    public List<Conflict> getMergeData() {
        return this.myConflicts;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getCaption();
    }

    @Override
    public int getRowCount() {
        return this.myConflicts != null ? this.myConflicts.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Conflict conflict = this.myConflicts.get(rowIndex);
        return Column.values()[columnIndex].getValue(conflict);
    }

    public List<Conflict> getConflicts() {
        return this.myConflicts;
    }

    public void setConflicts(List<Conflict> conflicts) {
        this.myConflicts = conflicts;
        this.fireTableDataChanged();
    }

    public static enum Column {
        Name("Name"){

            @Override
            public String getValue(Conflict conflict) {
                if (conflict.getCtype() == ConflictType.Merge) {
                    return VersionControlPath.localPathFromTfsRepresentation(conflict.getTgtlitem() != null ? conflict.getTgtlitem() : conflict.getSrclitem());
                }
                return VersionControlPath.localPathFromTfsRepresentation(conflict.getSrclitem() != null ? conflict.getSrclitem() : conflict.getTgtlitem());
            }
        };

        private final String myCaption;

        private Column(String caption) {
            this.myCaption = caption;
        }

        public String getCaption() {
            return this.myCaption;
        }

        public abstract String getValue(Conflict var1);
    }
}

