/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionControlLabel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ApplyLabelForm;

public class ApplyLabelDialog
extends DialogWrapper {
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private final String mySourcePath;
    private ApplyLabelForm myApplyLabelForm;

    public ApplyLabelDialog(Project project, WorkspaceInfo workspace, String sourcePath) {
        super(project, true);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.mySourcePath = sourcePath;
        this.setTitle("Apply Label");
        this.init();
        this.setOKActionEnabled(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myApplyLabelForm = new ApplyLabelForm(this.myProject, this.myWorkspace, this.mySourcePath);
        this.getWindow().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ApplyLabelDialog.this.myApplyLabelForm.addItems();
            }
        });
        this.myApplyLabelForm.addListener(new ApplyLabelForm.Listener(){

            @Override
            public void dataChanged(String labelName, int visibleItemsCount) {
                ApplyLabelDialog.this.setOKActionEnabled(visibleItemsCount > 0 && labelName.length() > 0);
            }
        });
        return this.myApplyLabelForm.getContentPane();
    }

    protected void doOKAction() {
        try {
            String message;
            List<VersionControlLabel> labels = this.myWorkspace.getServer().getVCS().queryLabels(this.getLabelName(), null, null, false, null, null, false, this.myApplyLabelForm.getContentPane(), TFSBundle.message("checking.existing.labels", new Object[0]));
            if (!labels.isEmpty() && Messages.showOkCancelDialog((Project)this.myProject, (String)(message = MessageFormat.format("Label ''{0}'' already exists.\nDo you want to update it?", this.getLabelName())), (String)this.getTitle(), (String)"Update Label", (String)"Cancel", (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.getTitle());
            return;
        }
        super.doOKAction();
    }

    public String getLabelName() {
        return this.myApplyLabelForm.getLabelName();
    }

    public String getLabelComment() {
        return this.myApplyLabelForm.getLabelComment();
    }

    public List<LabelItemSpec> getLabelItemSpecs() {
        return this.myApplyLabelForm.getLabelItemSpecs();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ApplyLabel";
    }
}

