/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.ui.SelectRevisionForm;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class AddItemForm
implements Disposable {
    private JPanel myContentPane;
    private SelectRevisionForm mySelectRevisionForm;
    private TfsTreeForm myTreeForm;
    private TitledSeparator myServerItemSeparator;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public AddItemForm(final Project project, final WorkspaceInfo workspace, String serverPath) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myServerItemSeparator.setLabelFor((Component)this.myTreeForm.getPreferredFocusedComponent());
        Disposer.register((Disposable)this, (Disposable)this.myTreeForm);
        this.myTreeForm.addListener(new TfsTreeForm.SelectionListener(){

            @Override
            public void selectionChanged() {
                TfsTreeForm.SelectedItem selectedItem = AddItemForm.this.myTreeForm.getSelectedItem();
                if (selectedItem != null) {
                    AddItemForm.this.mySelectRevisionForm.init(project, workspace, selectedItem.path, selectedItem.isDirectory);
                }
                ((ChangeListener)AddItemForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.mySelectRevisionForm.addListener(new SelectRevisionForm.Listener(){

            @Override
            public void revisionChanged() {
                ((ChangeListener)AddItemForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myTreeForm.initialize(workspace.getServer(), serverPath, false, false, null);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Nullable
    public TfsTreeForm.SelectedItem getServerItem() {
        return this.myTreeForm.getSelectedItem();
    }

    @Nullable
    public VersionSpecBase getVersion() {
        return this.mySelectRevisionForm.getVersionSpec();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeForm.getPreferredFocusedComponent();
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        TfsTreeForm tfsTreeForm;
        SelectRevisionForm selectRevisionForm;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Version", (int)0, (int)0, null, null));
        this.mySelectRevisionForm = selectRevisionForm = new SelectRevisionForm();
        JComponent jComponent = selectRevisionForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTreeForm = tfsTreeForm = new TfsTreeForm();
        JComponent jComponent2 = tfsTreeForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myServerItemSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Server item");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

