/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.exceptions;

import org.apache.commons.httpclient.HttpStatus;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class ConnectionFailedException
extends TfsException {
    private static final long serialVersionUID = 1L;
    private static final int CODE_UNDEFINED = 0;
    private final int myHttpStatusCode;
    private final String myMessage;

    public ConnectionFailedException(Throwable cause, int httpStatusCode) {
        super(cause);
        this.myHttpStatusCode = httpStatusCode;
        this.myMessage = null;
    }

    public ConnectionFailedException(Throwable cause) {
        this(cause, 0);
    }

    public ConnectionFailedException(Throwable cause, String message) {
        super(cause);
        this.myHttpStatusCode = 0;
        this.myMessage = message;
    }

    @Override
    public String getMessage() {
        if (this.myMessage != null) {
            return this.myMessage;
        }
        String message = super.getMessage();
        if (message != null) {
            return message;
        }
        if (this.myHttpStatusCode != 0) {
            return HttpStatus.getStatusText((int)this.myHttpStatusCode);
        }
        return null;
    }

    public int getHttpStatusCode() {
        return this.myHttpStatusCode;
    }
}

