/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.workitems;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WorkItemState {
    private static final Map<String, WorkItemState> ourAllStates = ContainerUtil.newHashMap();
    public static final WorkItemState ACTIVE = WorkItemState.register("Active");
    public static final WorkItemState RESOLVED = WorkItemState.register("Resolved");
    public static final WorkItemState CLOSED = WorkItemState.register("Closed");
    @NonNls
    @NotNull
    private final String myName;

    private WorkItemState(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "<init>"));
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "getName"));
        }
        return string;
    }

    @NotNull
    public static WorkItemState from(@NotNull String stateName) {
        if (stateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateName", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "from"));
        }
        WorkItemState workItemState = WorkItemState.register(stateName);
        if (workItemState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "from"));
        }
        return workItemState;
    }

    @NotNull
    private static synchronized WorkItemState register(@NotNull String stateName) {
        if (stateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateName", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "register"));
        }
        WorkItemState result = ourAllStates.get(stateName);
        if (result == null) {
            result = new WorkItemState(stateName);
            ourAllStates.put(stateName, result);
        }
        WorkItemState workItemState = result;
        if (workItemState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState", "register"));
        }
        return workItemState;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkItemState)) {
            return false;
        }
        WorkItemState state = (WorkItemState)o;
        return this.myName.equals(state.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

