/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.workitems;

import com.intellij.openapi.util.text.StringUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.fields.FieldCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemField;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemState;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemType;

public class WorkItem {
    private final int myId;
    @Nullable
    private final String myAssignedTo;
    private final WorkItemState myState;
    private final String myTitle;
    private final int myRevision;
    private final WorkItemType myType;
    private final String myReason;

    public WorkItem(int id, @Nullable String assignedTo, WorkItemState state, String title, int revision, WorkItemType type, String reason) {
        this.myAssignedTo = assignedTo;
        this.myId = id;
        this.myReason = reason;
        this.myRevision = revision;
        this.myState = state;
        this.myTitle = title;
        this.myType = type;
    }

    @NotNull
    public static WorkItem create(@NotNull com.microsoft.tfs.core.clients.workitem.WorkItem workItem) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItem", "create"));
        }
        int id = workItem.getID();
        String assignedTo = WorkItem.getStringValue(workItem, WorkItemField.ASSIGNED_TO);
        String state = WorkItem.getStringValue(workItem, WorkItemField.STATE);
        String title = workItem.getTitle();
        int revision = workItem.getFields().getRevision();
        String type = workItem.getType().getName();
        String reason = WorkItem.getStringValue(workItem, WorkItemField.REASON);
        WorkItem workItem2 = new WorkItem(id, assignedTo, WorkItemState.from(state), title, revision, WorkItemType.from(type), reason);
        if (workItem2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItem", "create"));
        }
        return workItem2;
    }

    @NotNull
    private static String getStringValue(@NotNull com.microsoft.tfs.core.clients.workitem.WorkItem workItem, @NotNull WorkItemField field) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItem", "getStringValue"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItem", "getStringValue"));
        }
        FieldCollection fields = workItem.getFields();
        String result = null;
        if (fields.contains(field.getSerialized())) {
            result = (String)fields.getField(field.getSerialized()).getValue();
        }
        String string = StringUtil.notNullize(result);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItem", "getStringValue"));
        }
        return string;
    }

    public int getId() {
        return this.myId;
    }

    @Nullable
    public String getAssignedTo() {
        return this.myAssignedTo;
    }

    public WorkItemState getState() {
        return this.myState;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public int getRevision() {
        return this.myRevision;
    }

    public WorkItemType getType() {
        return this.myType;
    }

    public String getReason() {
        return this.myReason;
    }

    public boolean isActionPossible(CheckinWorkItemAction action) {
        return action == CheckinWorkItemAction.None || action == CheckinWorkItemAction.Associate || this.myState == WorkItemState.ACTIVE && (this.myType == WorkItemType.BUG || this.myType == WorkItemType.TASK);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkItem workItem = (WorkItem)o;
        return this.myId == workItem.myId;
    }

    public int hashCode() {
        return this.myId;
    }

    public String toString() {
        return this.myTitle;
    }
}

