/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.util.io.FileUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;

public class GetOperationsUtil {
    static List<GetOperation> sortGetOperations(Collection<GetOperation> getOperations) {
        ArrayList<GetOperation> result = new ArrayList<GetOperation>(getOperations.size());
        for (GetOperation newOperation : getOperations) {
            TFSVcs.assertTrue(newOperation.getSlocal() != null || newOperation.getTlocal() != null);
            int positionToInsert = result.size();
            if (newOperation.getSlocal() != null) {
                File newOpPath = VersionControlPath.getFile(newOperation.getSlocal());
                for (int i = 0; i < result.size(); ++i) {
                    GetOperation existingOperation = (GetOperation)result.get(i);
                    if (existingOperation.getSlocal() != null && !FileUtil.isAncestor((File)newOpPath, (File)VersionControlPath.getFile(existingOperation.getSlocal()), (boolean)false)) continue;
                    positionToInsert = i;
                    break;
                }
            }
            result.add(positionToInsert, newOperation);
        }
        return result;
    }

    public static void updateSourcePaths(List<GetOperation> sortedOperations, int index, GetOperation operation) {
        for (GetOperation operationToUpdate : sortedOperations.subList(index + 1, sortedOperations.size())) {
            if (operationToUpdate.getSlocal() == null) continue;
            String updated = operationToUpdate.getSlocal().replace(operation.getSlocal(), operation.getTlocal());
            operationToUpdate.setSlocal(updated);
        }
    }
}

