/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.locks;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;

public class LockItemModel {
    @NotNull
    private final ExtendedItem myExtendedItem;
    @NotNull
    private final WorkspaceInfo myWorkspace;
    @Nullable
    private Boolean mySelectionStatus;
    public static final Comparator<LockItemModel> LOCK_ITEM_PARENT_FIRST = new Comparator<LockItemModel>(){

        @Override
        public int compare(LockItemModel o1, LockItemModel o2) {
            return VersionControlPath.compareParentToChild(o1.getExtendedItem().getSitem(), o1.getExtendedItem().getType() == ItemType.Folder, o2.getExtendedItem().getSitem(), o2.getExtendedItem().getType() == ItemType.Folder);
        }
    };

    public LockItemModel(@NotNull ExtendedItem item, @NotNull WorkspaceInfo workspace) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel", "<init>"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel", "<init>"));
        }
        this.myExtendedItem = item;
        this.myWorkspace = workspace;
        this.mySelectionStatus = this.canBeLocked() || this.canBeUnlocked() ? Boolean.FALSE : null;
    }

    @NotNull
    public ExtendedItem getExtendedItem() {
        ExtendedItem extendedItem = this.myExtendedItem;
        if (extendedItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel", "getExtendedItem"));
        }
        return extendedItem;
    }

    @NotNull
    public WorkspaceInfo getWorkspace() {
        WorkspaceInfo workspaceInfo = this.myWorkspace;
        if (workspaceInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel", "getWorkspace"));
        }
        return workspaceInfo;
    }

    @Nullable
    public Boolean getSelectionStatus() {
        return this.mySelectionStatus;
    }

    public void setSelectionStatus(@NotNull Boolean selectionStatus) {
        if (selectionStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionStatus", "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel", "setSelectionStatus"));
        }
        if (this.mySelectionStatus == null) {
            throw new IllegalArgumentException("State of items locked by another user cannot be changed.");
        }
        this.mySelectionStatus = selectionStatus;
    }

    @Nullable
    public String getLockOwner() {
        return this.myExtendedItem.getLowner() != null ? TfsUtil.getNameWithoutDomain(this.myExtendedItem.getLowner()) : null;
    }

    public boolean canBeLocked() {
        return this.myExtendedItem.getLock() == null || this.myExtendedItem.getLock() == LockLevel.None;
    }

    public boolean canBeUnlocked() {
        return this.myWorkspace.getOwnerName().equalsIgnoreCase(this.myExtendedItem.getLowner());
    }
}

