/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.conflicts;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ContentMerger;
import org.jetbrains.tfsIntegration.ui.ContentTriplet;

public class DialogContentMerger
implements ContentMerger {
    @Override
    public boolean mergeContent(Conflict conflict, ContentTriplet contentTriplet, Project project, final VirtualFile localFile, String localPath, VcsRevisionNumber serverVersion) {
        TFSVcs.assertTrue(localFile.isWritable(), localFile.getPresentableUrl() + " must be writable");
        MergeDialogCustomizer c = new MergeDialogCustomizer();
        MergeRequest request = DiffRequestFactory.getInstance().createMergeRequest(StreamUtil.convertSeparators((String)contentTriplet.localContent), StreamUtil.convertSeparators((String)contentTriplet.serverContent), StreamUtil.convertSeparators((String)contentTriplet.baseContent), localFile, project, ActionButtonPresentation.APPLY, ActionButtonPresentation.CANCEL_WITH_PROMPT);
        request.setWindowTitle(c.getMergeWindowTitle(localFile));
        request.setVersionTitles(new String[]{c.getLeftPanelTitle(localFile), c.getCenterPanelTitle(localFile), c.getRightPanelTitle(localFile, serverVersion)});
        DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        if (request.getResult() == 0) {
            return true;
        }
        request.restoreOriginalContent();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Document document = FileDocumentManager.getInstance().getDocument(localFile);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }
        });
        return false;
    }
}

