/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.microsoft.schemas.teamfoundation._2005._06.services.groupsecurity._03.GroupSecurityServiceStub;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.ArrayOfFrameworkRegistrationEntry;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.FrameworkRegistrationEntry;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.GetRegistrationEntries;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.RegistrationServiceInterface;
import com.microsoft.schemas.teamfoundation._2005._06.services.registration._03.RegistrationStub;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RepositoryStub;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.ClientService2Stub;
import java.net.URI;
import java.rmi.RemoteException;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.exceptions.HostNotApplicableException;
import org.jetbrains.tfsIntegration.webservice.WebServiceHelper;

public class TfsBeansHolder {
    private static final Logger LOG = Logger.getInstance((String)TfsBeansHolder.class.getName());
    private final URI myServerUri;
    private RepositoryStub myRepository;
    private RepositoryStub myRepository4;
    private ClientService2Stub myWorkItemTrackingClientService;
    private GroupSecurityServiceStub myGroupSecurityService;
    private String myDownloadUrl;
    private String myUploadUrl;
    private HttpClient[] myUploadDownloadClients = new HttpClient[2];

    public TfsBeansHolder(URI serverUri) {
        this.myServerUri = serverUri;
    }

    @NotNull
    public RepositoryStub getRepositoryStub(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myRepository == null) {
            this.createStubs(credentials, pi);
        }
        WebServiceHelper.setupStub((Stub)this.myRepository, credentials, this.myServerUri);
        RepositoryStub repositoryStub = this.myRepository;
        if (repositoryStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getRepositoryStub"));
        }
        return repositoryStub;
    }

    @NotNull
    public RepositoryStub getRepository4Stub(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myRepository4 == null) {
            this.createStubs(credentials, pi);
        }
        WebServiceHelper.setupStub((Stub)this.myRepository4, credentials, this.myServerUri);
        RepositoryStub repositoryStub = this.myRepository4;
        if (repositoryStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getRepository4Stub"));
        }
        return repositoryStub;
    }

    @NotNull
    public ClientService2Stub getWorkItemServiceStub(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myWorkItemTrackingClientService == null) {
            this.createStubs(credentials, pi);
        }
        WebServiceHelper.setupStub((Stub)this.myWorkItemTrackingClientService, credentials, this.myServerUri);
        ClientService2Stub clientService2Stub = this.myWorkItemTrackingClientService;
        if (clientService2Stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getWorkItemServiceStub"));
        }
        return clientService2Stub;
    }

    @NotNull
    public GroupSecurityServiceStub getGroupSecurityServiceStub(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myGroupSecurityService == null) {
            this.createStubs(credentials, pi);
        }
        WebServiceHelper.setupStub((Stub)this.myGroupSecurityService, credentials, this.myServerUri);
        GroupSecurityServiceStub groupSecurityServiceStub = this.myGroupSecurityService;
        if (groupSecurityServiceStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getGroupSecurityServiceStub"));
        }
        return groupSecurityServiceStub;
    }

    @NotNull
    public String getDownloadUrl(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myDownloadUrl == null) {
            this.createStubs(credentials, pi);
        }
        String string = this.myDownloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getDownloadUrl"));
        }
        return string;
    }

    @NotNull
    public String getUploadUrl(Credentials credentials, ProgressIndicator pi) throws HostNotApplicableException, RemoteException {
        if (this.myUploadUrl == null) {
            this.createStubs(credentials, pi);
        }
        String string = this.myUploadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsBeansHolder", "getUploadUrl"));
        }
        return string;
    }

    private void createStubs(Credentials authorizedCredentials, @Nullable ProgressIndicator pi) throws RemoteException, HostNotApplicableException {
        String piText;
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        String string = piText = pi != null ? pi.getText() : null;
        if (pi != null) {
            pi.setText(TFSBundle.message("loading.services", new Object[0]));
        }
        ConfigurationContext configContext = WebServiceHelper.getStubConfigurationContext();
        RegistrationStub registrationStub = new RegistrationStub(configContext, TfsUtil.appendPath(this.myServerUri, "Services/v1.0/Registration.asmx"));
        WebServiceHelper.setupStub((Stub)registrationStub, authorizedCredentials, this.myServerUri);
        GetRegistrationEntries getRegistrationEntriesParam = new GetRegistrationEntries();
        ArrayOfFrameworkRegistrationEntry registrationEntries = registrationStub.getRegistrationEntries(getRegistrationEntriesParam).getGetRegistrationEntriesResult();
        String isccProvider = TfsBeansHolder.findServicePath(registrationEntries, "VersionControl", "ISCCProvider");
        if (isccProvider == null) {
            throw new HostNotApplicableException(null);
        }
        String isccProvider4 = TfsBeansHolder.findServicePath(registrationEntries, "VersionControl", "ISCCProvider4", "ISCCProvider");
        if (isccProvider4 == null) {
            throw new HostNotApplicableException(null);
        }
        String download = TfsBeansHolder.findServicePath(registrationEntries, "VersionControl", "Download");
        if (download == null) {
            throw new HostNotApplicableException(null);
        }
        String upload = TfsBeansHolder.findServicePath(registrationEntries, "VersionControl", "Upload");
        if (upload == null) {
            throw new HostNotApplicableException(null);
        }
        String workItemService = TfsBeansHolder.findServicePath(registrationEntries, "WorkItemTracking", "WorkitemService");
        if (workItemService == null) {
            throw new HostNotApplicableException(null);
        }
        String groupSecurityService = TfsBeansHolder.findServicePath(registrationEntries, "vstfs", "GroupSecurity");
        if (groupSecurityService == null) {
            throw new HostNotApplicableException(null);
        }
        this.doCreateStubs(configContext, isccProvider, isccProvider4, download, upload, workItemService, groupSecurityService);
        if (pi != null) {
            pi.setText(piText);
        }
    }

    private void doCreateStubs(@Nullable ConfigurationContext configContext, String isccProvider, String isccProvider4, String download, String upload, String workItemService, String groupSecurity) {
        this.myDownloadUrl = download;
        this.myUploadUrl = upload;
        try {
            if (configContext == null) {
                configContext = WebServiceHelper.getStubConfigurationContext();
            }
            this.myRepository = new RepositoryStub(configContext, TfsUtil.appendPath(this.myServerUri, isccProvider));
            this.myRepository4 = new RepositoryStub(configContext, TfsUtil.appendPath(this.myServerUri, isccProvider4));
            this.myWorkItemTrackingClientService = new ClientService2Stub(configContext, TfsUtil.appendPath(this.myServerUri, workItemService));
            this.myGroupSecurityService = new GroupSecurityServiceStub(configContext, TfsUtil.appendPath(this.myServerUri, groupSecurity));
        }
        catch (Exception e) {
            LOG.error("Failed to initialize web service stub", (Throwable)e);
        }
    }

    public HttpClient getUploadDownloadClient(boolean forProxy) {
        int index;
        int n = index = forProxy ? 1 : 0;
        if (this.myUploadDownloadClients[index] == null) {
            MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
            this.myUploadDownloadClients[index] = new HttpClient((HttpConnectionManager)connManager);
            HttpClientParams clientParams = new HttpClientParams();
            clientParams.setConnectionManagerTimeout(30000L);
            this.myUploadDownloadClients[index].setParams(clientParams);
        }
        return this.myUploadDownloadClients[index];
    }

    @Nullable
    private static String findServicePath(ArrayOfFrameworkRegistrationEntry registrationEntries, String entryType, String ... interfaceNames) {
        if (registrationEntries == null) {
            return null;
        }
        for (FrameworkRegistrationEntry entry : registrationEntries.getRegistrationEntry()) {
            RegistrationServiceInterface[] interfaces;
            if (!entryType.equals(entry.getType()) || (interfaces = entry.getServiceInterfaces().getServiceInterface()) == null) continue;
            for (String interfaceName : interfaceNames) {
                for (RegistrationServiceInterface anInterface : interfaces) {
                    if (!interfaceName.equals(anInterface.getName())) continue;
                    return anInterface.getUrl();
                }
            }
        }
        return null;
    }
}

