/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusProvider;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.operations.UndoPendingChanges;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.WorkspaceVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSRollbackEnvironment
extends DefaultRollbackEnvironment {
    @NotNull
    private final Project myProject;

    public TFSRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment", "rollbackChanges"));
        }
        ArrayList<FilePath> localPaths = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            ContentRevision revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
            localPaths.add(revision.getFile());
        }
        this.undoPendingChanges(localPaths, vcsExceptions, listener, false);
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, final List<VcsException> errors, final RollbackProgressListener listener) {
        try {
            WorkstationHelper.processByWorkspaces(files, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    final ArrayList<VersionControlServer.GetRequestParams> download = new ArrayList<VersionControlServer.GetRequestParams>();
                    final ArrayList<String> undo = new ArrayList<String>();
                    StatusProvider.visitByStatus(workspace, paths, false, null, new StatusVisitor(){

                        @Override
                        public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "unversioned"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "unversioned"));
                            }
                            TFSVcs.error("Server returned status Unversioned when rolling back missing file deletion: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "checkedOutForEdit"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "checkedOutForEdit"));
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "scheduledForAddition"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "scheduledForAddition"));
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "scheduledForDeletion"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "scheduledForDeletion"));
                            }
                            TFSVcs.error("Server returned status ScheduledForDeletion when rolling back missing file deletion: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "outOfDate"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "outOfDate"));
                            }
                            this.addForDownload(serverStatus);
                        }

                        @Override
                        public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "deleted"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "deleted"));
                            }
                            TFSVcs.error("Server returned status Deleted when rolling back missing file deletion: " + localPath.getPath());
                        }

                        @Override
                        public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "upToDate"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "upToDate"));
                            }
                            this.addForDownload(serverStatus);
                        }

                        @Override
                        public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "renamed"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "renamed"));
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "renamedCheckedOut"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "renamedCheckedOut"));
                            }
                            undo.add(serverStatus.targetItem);
                        }

                        @Override
                        public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "undeleted"));
                            }
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "undeleted"));
                            }
                            this.addForDownload(serverStatus);
                        }

                        private void addForDownload(@NotNull ServerStatus serverStatus) {
                            if (serverStatus == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment$1$1", "addForDownload"));
                            }
                            download.add(new VersionControlServer.GetRequestParams(serverStatus.targetItem, RecursionType.None, new ChangesetVersionSpec(serverStatus.localVer)));
                        }
                    }, TFSRollbackEnvironment.this.myProject);
                    List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), download, TFSRollbackEnvironment.this.myProject, TFSBundle.message("preparing.for.download", new Object[0]));
                    Collection<VcsException> downloadErrors = ApplyGetOperations.execute(TFSRollbackEnvironment.this.myProject, workspace, operations, ApplyProgress.EMPTY, null, ApplyGetOperations.DownloadMode.FORCE);
                    errors.addAll(downloadErrors);
                    UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(TFSRollbackEnvironment.this.myProject, workspace, undo, false, new ApplyProgress.RollbackProgressWrapper(listener), false);
                    errors.addAll(undoResult.errors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException(e.getMessage(), (Throwable)e));
        }
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, final List<VcsException> errors, final RollbackProgressListener listener) {
        try {
            WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(files), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    ArrayList<VersionControlServer.GetRequestParams> requests = new ArrayList<VersionControlServer.GetRequestParams>(paths.size());
                    WorkspaceVersionSpec versionSpec = new WorkspaceVersionSpec(workspace.getName(), workspace.getOwnerName());
                    for (ItemPath e : paths) {
                        requests.add(new VersionControlServer.GetRequestParams(e.getServerPath(), RecursionType.None, versionSpec));
                    }
                    List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), requests, TFSRollbackEnvironment.this.myProject, TFSBundle.message("preparing.for.download", new Object[0]));
                    Collection<VcsException> applyingErrors = ApplyGetOperations.execute(TFSRollbackEnvironment.this.myProject, workspace, operations, new ApplyProgress.RollbackProgressWrapper(listener), null, ApplyGetOperations.DownloadMode.FORCE);
                    errors.addAll(applyingErrors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException("Cannot undo pending changes", (Throwable)e));
        }
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void undoPendingChanges(List<FilePath> localPaths, final List<VcsException> errors, final @NotNull RollbackProgressListener listener, final boolean tolerateNoChangesFailure) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/tfsIntegration/core/TFSRollbackEnvironment", "undoPendingChanges"));
        }
        try {
            WorkstationHelper.processByWorkspaces(localPaths, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    ArrayList<String> serverPaths = new ArrayList<String>(paths.size());
                    for (ItemPath itemPath : paths) {
                        serverPaths.add(itemPath.getServerPath());
                    }
                    UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(TFSRollbackEnvironment.this.myProject, workspace, serverPaths, false, new ApplyProgress.RollbackProgressWrapper(listener), tolerateNoChangesFailure);
                    errors.addAll(undoResult.errors);
                    ArrayList<VirtualFile> refresh = new ArrayList<VirtualFile>(paths.size());
                    for (ItemPath path : paths) {
                        listener.accept(path.getLocalPath());
                        ItemPath undone = undoResult.undonePaths.get(path);
                        FilePath subject = (undone != null ? undone : path).getLocalPath();
                        VirtualFile file = subject.getVirtualFileParent();
                        if (file == null || !file.exists()) continue;
                        refresh.add(file);
                    }
                    TfsFileUtil.refreshAndMarkDirty(TFSRollbackEnvironment.this.myProject, refresh, true);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException("Cannot undo pending changes", (Throwable)e));
        }
    }
}

