/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;

public class TFSRepositoryLocation
implements RepositoryLocation {
    private final Map<WorkspaceInfo, List<FilePath>> myPathsByWorkspaces;

    public TFSRepositoryLocation(Map<WorkspaceInfo, List<FilePath>> pathsByWorkspaces) {
        this.myPathsByWorkspaces = pathsByWorkspaces;
    }

    public Map<WorkspaceInfo, List<FilePath>> getPathsByWorkspaces() {
        return this.myPathsByWorkspaces;
    }

    public String getKey() {
        return this.toString();
    }

    public void onBeforeBatch() throws VcsException {
    }

    public void onAfterBatch() {
    }

    public String toPresentableString() {
        if (this.myPathsByWorkspaces.size() == 1 && this.myPathsByWorkspaces.values().iterator().next().size() == 1) {
            return this.myPathsByWorkspaces.values().iterator().next().iterator().next().getPresentableUrl();
        }
        return "Multiple paths";
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Collection collection : this.myPathsByWorkspaces.values()) {
            for (FilePath path : collection) {
                s.append(path.getPath());
            }
        }
        return s.toString();
    }
}

