/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSFileRevision
implements VcsFileRevision {
    private final Project myProject;
    private final Date myDate;
    @Nullable
    private byte[] myContent;
    private final String myCommitMessage;
    private final String myAuthor;
    private final int myItemId;
    private final int myChangeset;
    private final WorkspaceInfo myWorkspace;

    public TFSFileRevision(Project project, WorkspaceInfo workspace, int itemId, Date date, String commitMessage, String author, int changeset) {
        this.myProject = project;
        this.myWorkspace = workspace;
        this.myDate = date;
        this.myCommitMessage = commitMessage;
        this.myAuthor = author;
        this.myChangeset = changeset;
        this.myItemId = itemId;
    }

    @NotNull
    public VcsRevisionNumber.Int getRevisionNumber() {
        TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(this.myChangeset, this.myItemId);
        if (tfsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSFileRevision", "getRevisionNumber"));
        }
        return tfsRevisionNumber;
    }

    public String getBranchName() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myDate;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public byte[] loadContent() throws IOException, VcsException {
        this.myContent = this.createContentRevision().getContentAsBytes();
        return this.myContent;
    }

    @Nullable
    public byte[] getContent() throws IOException, VcsException {
        return this.myContent;
    }

    public TFSContentRevision createContentRevision() throws VcsException {
        try {
            return TFSContentRevision.create(this.myProject, this.myWorkspace, this.myChangeset, this.myItemId);
        }
        catch (TfsException e) {
            throw new VcsException("Cannot get revision content", (Throwable)e);
        }
    }
}

