/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

class ChangelistBuilderStatusVisitor
implements StatusVisitor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final WorkspaceInfo myWorkspace;

    public ChangelistBuilderStatusVisitor(@NotNull Project project, @NotNull ChangelistBuilder changelistBuilder, @NotNull WorkspaceInfo workspace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "<init>"));
        }
        if (changelistBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changelistBuilder", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "<init>"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "<init>"));
        }
        this.myProject = project;
        this.myChangelistBuilder = changelistBuilder;
        this.myWorkspace = workspace;
    }

    @Override
    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "unversioned"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "unversioned"));
        }
        if (localItemExists) {
            this.myChangelistBuilder.processUnversionedFile(localPath.getVirtualFile());
        }
    }

    @Override
    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "checkedOutForEdit"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "checkedOutForEdit"));
        }
        if (localItemExists) {
            TFSContentRevision baseRevision = TFSContentRevision.create(this.myProject, this.myWorkspace, localPath, serverStatus.localVer, serverStatus.itemId);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)baseRevision, CurrentContentRevision.create((FilePath)localPath)), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "scheduledForAddition"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "scheduledForAddition"));
        }
        if (localItemExists) {
            this.myChangelistBuilder.processChange(new Change(null, (ContentRevision)new CurrentContentRevision(localPath)), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "scheduledForDeletion"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "scheduledForDeletion"));
        }
        TFSContentRevision baseRevision = TFSContentRevision.create(this.myProject, this.myWorkspace, localPath, serverStatus.localVer, serverStatus.itemId);
        this.myChangelistBuilder.processChange(new Change((ContentRevision)baseRevision, null), TFSVcs.getKey());
    }

    @Override
    public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatusm) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "outOfDate"));
        }
        if (serverStatusm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatusm", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "outOfDate"));
        }
        this.upToDate(localPath, localItemExists, serverStatusm);
    }

    @Override
    public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "deleted"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "deleted"));
        }
        if (localItemExists) {
            this.myChangelistBuilder.processUnversionedFile(localPath.getVirtualFile());
        }
    }

    @Override
    public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "upToDate"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "upToDate"));
        }
        if (localItemExists) {
            if (!this.myWorkspace.isLocal() && TfsFileUtil.isFileWritable(localPath)) {
                this.myChangelistBuilder.processModifiedWithoutCheckout(localPath.getVirtualFile());
            }
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "renamed"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "renamed"));
        }
        if (localItemExists) {
            FilePath beforePath = this.myWorkspace.findLocalPathByServerPath(serverStatus.sourceItem, serverStatus.isDirectory, this.myProject);
            TFSContentRevision before = TFSContentRevision.create(this.myProject, this.myWorkspace, beforePath, serverStatus.localVer, serverStatus.itemId);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "renamedCheckedOut"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "renamedCheckedOut"));
        }
        if (localItemExists) {
            FilePath beforePath = this.myWorkspace.findLocalPathByServerPath(serverStatus.sourceItem, serverStatus.isDirectory, this.myProject);
            TFSContentRevision before = TFSContentRevision.create(this.myProject, this.myWorkspace, beforePath, serverStatus.localVer, serverStatus.itemId);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "undeleted"));
        }
        if (serverStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverStatus", "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor", "undeleted"));
        }
        this.checkedOutForEdit(localPath, localItemExists, serverStatus);
    }
}

