/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;

public class PolicyFailure {
    @NotNull
    private final PolicyBase myPolicy;
    @NotNull
    private final String myMessage;
    @Nullable
    private final String myTooltipText;

    public PolicyFailure(@NotNull PolicyBase policy, @NotNull String message) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "<init>"));
        }
        this(policy, message, null);
    }

    public PolicyFailure(@NotNull PolicyBase policy, @NotNull String message, @Nullable String tooltipText) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "<init>"));
        }
        this.myPolicy = policy;
        this.myMessage = message;
        this.myTooltipText = tooltipText;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "getMessage"));
        }
        return string;
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltipText;
    }

    public void activate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/checkin/PolicyFailure", "activate"));
        }
        this.myPolicy.activate(project, this);
    }

    public String getPolicyName() {
        return this.myPolicy.getPolicyType().getName();
    }
}

