/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.text.MessageFormat;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.checkin.PolicyContext;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyType;

public abstract class PolicyBase {
    public static final ExtensionPointName<PolicyBase> EP_NAME = new ExtensionPointName("TFS.checkinPolicy");
    protected static final PolicyFailure[] NO_FAILURES = new PolicyFailure[0];

    @NotNull
    public abstract PolicyType getPolicyType();

    public abstract PolicyFailure[] evaluate(@NotNull PolicyContext var1, @NotNull ProgressIndicator var2);

    public abstract boolean canEdit();

    public abstract boolean edit(Project var1);

    public abstract void loadState(@NotNull Element var1);

    public abstract void saveState(@NotNull Element var1);

    public void activate(@NotNull Project project, @NotNull PolicyFailure policyFailure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/checkin/PolicyBase", "activate"));
        }
        if (policyFailure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policyFailure", "org/jetbrains/tfsIntegration/checkin/PolicyBase", "activate"));
        }
        String message = policyFailure.getTooltipText() != null ? MessageFormat.format("{0}\n\n{1}", policyFailure.getMessage(), policyFailure.getTooltipText()) : policyFailure.getMessage();
        Messages.showWarningDialog((Project)project, (String)message, (String)"Checkin Policy Warning");
    }
}

