/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.actions.SingleItemAction;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ApplyLabelDialog;

public class LabelAction
extends SingleItemAction
implements DumbAware {
    @Override
    protected void execute(@NotNull Project project, @NotNull WorkspaceInfo workspace, @NotNull FilePath localPath, @NotNull ExtendedItem extendedItem) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/actions/LabelAction", "execute"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/actions/LabelAction", "execute"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/actions/LabelAction", "execute"));
        }
        if (extendedItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/actions/LabelAction", "execute"));
        }
        ApplyLabelDialog d = new ApplyLabelDialog(project, workspace, extendedItem.getSitem());
        if (!d.showAndGet()) {
            return;
        }
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            ResultWithFailures<LabelResult> resultWithFailures = workspace.getServer().getVCS().labelItem(d.getLabelName(), d.getLabelComment(), d.getLabelItemSpecs(), project, TFSBundle.message("creating.label", new Object[0]));
            errors.addAll(TfsUtil.getVcsExceptions(resultWithFailures.getFailures()));
            StringBuffer buffer = new StringBuffer();
            for (LabelResult labelResult : resultWithFailures.getResult()) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                String message = MessageFormat.format("Label ''{0}@{1}'' {2}", labelResult.getLabel(), labelResult.getScope(), labelResult.getStatus().getValue().toLowerCase());
                buffer.append(message);
            }
            if (buffer.length() > 0) {
                TfsUtil.showBalloon(project, MessageType.INFO, buffer.toString());
            }
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, "TFS: Apply Label");
        }
    }
}

