/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.BranchRelative;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.actions.SingleItemAction;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ItemInfoDialog;

public class ItemInfoAction
extends SingleItemAction
implements DumbAware {
    private static final Collection<FileStatus> ALLOWED_STATUSES = Arrays.asList(FileStatus.HIJACKED, FileStatus.MODIFIED, FileStatus.NOT_CHANGED, FileStatus.OBSOLETE, FileStatus.ADDED);

    @Override
    protected Collection<FileStatus> getAllowedStatuses() {
        return ALLOWED_STATUSES;
    }

    @Override
    protected void execute(@NotNull Project project, @NotNull WorkspaceInfo workspace, @NotNull FilePath localPath, @NotNull ExtendedItem extendedItem) throws TfsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/actions/ItemInfoAction", "execute"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/actions/ItemInfoAction", "execute"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/actions/ItemInfoAction", "execute"));
        }
        if (extendedItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/actions/ItemInfoAction", "execute"));
        }
        if (extendedItem.getLver() == Integer.MIN_VALUE) {
            String itemType = localPath.isDirectory() ? "Folder" : "File";
            String message = MessageFormat.format("{0} ''{1}'' is unversioned", itemType, localPath.getPresentableUrl());
            Messages.showInfoMessage((Project)project, (String)message, (String)ItemInfoAction.getActionTitle(localPath.isDirectory()));
            return;
        }
        String serverPath = extendedItem.getTitem() != null ? extendedItem.getTitem() : extendedItem.getSitem();
        Collection<BranchRelative> branches = workspace.getServer().getVCS().queryBranches(serverPath, new ChangesetVersionSpec(extendedItem.getLver()), project, TFSBundle.message("loading.branches", new Object[0]));
        ItemInfoDialog d = new ItemInfoDialog(project, workspace, extendedItem, branches, ItemInfoAction.getActionTitle(localPath.isDirectory()));
        d.show();
    }

    private static String getActionTitle(boolean isDirectory) {
        return MessageFormat.format("{0} Information", isDirectory ? "Folder" : "File");
    }
}

