/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeStartupPolicy;
import com.intellij.javaee.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;

public class TomcatStartupPolicy
extends JavaeeStartupPolicy<TomcatLocalModel> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.tomcat.TomcatStartupPolicy");
    @NonNls
    protected static final String TEMP_FILE_NAME = "temp";
    @NonNls
    protected static final String BIN_DIR = "bin";
    @NonNls
    private static final String CATALINA_TMPDIR_ENV_PROPERTY = "CATALINA_TMPDIR";
    @NonNls
    private static final String JAVA_HOME_ENV_PROPERTY = "JAVA_HOME";
    @NonNls
    private static final String JRE_HOME_ENV_PROPERTY = "JRE_HOME";
    @NonNls
    private static final String JAVA_VM_ENV_VARIABLE = "JAVA_OPTS";
    @NonNls
    private static final String JAR_PARAMETER = "-jar";
    @NonNls
    public static final String CLASSPATH_PARAMETER = "-cp";
    @NonNls
    public static final String RMI_HOST_JAVA_OPT = "java.rmi.server.hostname";

    protected ExecutableObject getDefaultStartupScript(TomcatLocalModel serverModel, boolean debug) {
        try {
            return new ExecutableCreator(serverModel, "run", "start"){

                @Override
                protected List<String> getCustomJavaOptions() {
                    TomcatLocalModel tomcatModel = this.getTomcatModel();
                    if (tomcatModel.isUseJmx()) {
                        ArrayList<String> result = new ArrayList<String>(Arrays.asList("-Dcom.sun.management.jmxremote=", "-Dcom.sun.management.jmxremote.port=" + tomcatModel.JNDI_PORT, "-Dcom.sun.management.jmxremote.ssl=false", "-Dcom.sun.management.jmxremote.authenticate=false"));
                        if (tomcatModel.getVmArgument(TomcatStartupPolicy.RMI_HOST_JAVA_OPT) == null) {
                            result.add("-Djava.rmi.server.hostname=127.0.0.1");
                        }
                        if (tomcatModel.isTomEE()) {
                            if (tomcatModel.versionHigher(7, 0, 68)) {
                                result.add("-Dtomee.serialization.class.whitelist=");
                                result.add("-Dtomee.serialization.class.blacklist=-");
                            }
                            if (tomcatModel.versionHigher(8, 0, 28)) {
                                result.add("-Dtomee.remote.support=true");
                                result.add("-Dopenejb.system.apps=true");
                            }
                        }
                        return result;
                    }
                    return super.getCustomJavaOptions();
                }
            }.createExecutable();
        }
        catch (RuntimeConfigurationException e) {
            return null;
        }
    }

    protected ExecutableObject getDefaultShutdownScript(TomcatLocalModel serverModel, boolean debug) {
        try {
            return new ExecutableCreator(serverModel, "stop", "stop").createExecutable();
        }
        catch (RuntimeConfigurationException e) {
            return null;
        }
    }

    protected void getStartupParameters(JavaeeParameters params, TomcatLocalModel model, boolean debug) {
        throw new UnsupportedOperationException();
    }

    protected void getShutdownParameters(JavaeeParameters params, TomcatLocalModel model, boolean debug) {
        throw new UnsupportedOperationException();
    }

    protected List<EnvironmentVariable> getEnvironmentVariables(TomcatLocalModel tomcatModel) {
        try {
            ArrayList<EnvironmentVariable> vars = new ArrayList<EnvironmentVariable>();
            vars.add(new EnvironmentVariable("CATALINA_HOME", tomcatModel.getHomeDirectory(), true));
            vars.add(new EnvironmentVariable("CATALINA_BASE", tomcatModel.getBaseDirectoryPath(), true));
            String tmpDir = EnvironmentUtil.getValue((String)CATALINA_TMPDIR_ENV_PROPERTY);
            if (tmpDir == null) {
                vars.add(new EnvironmentVariable(CATALINA_TMPDIR_ENV_PROPERTY, TomcatStartupPolicy.getCatalinaTempDirectory(tomcatModel), true));
            }
            String[] javaEnvVars = new String[]{JAVA_HOME_ENV_PROPERTY, JRE_HOME_ENV_PROPERTY};
            String jrePath = tomcatModel.getJrePath();
            for (String varName : javaEnvVars) {
                TomcatStartupPolicy.setupJavaPath(vars, varName, jrePath);
            }
            return vars;
        }
        catch (RuntimeConfigurationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String getCatalinaTempDirectory(TomcatLocalModel tomcatModel) throws RuntimeConfigurationException {
        File tempDir = new File(tomcatModel.getSourceBaseDirectoryPath(), TEMP_FILE_NAME);
        if (!tempDir.exists() && !(tempDir = new File(tomcatModel.getBaseDirectoryPath(), TEMP_FILE_NAME)).exists()) {
            FileUtil.createDirectory((File)tempDir);
        }
        return tempDir.getAbsolutePath();
    }

    @NonNls
    public static String getDefaultCatalinaFileName() {
        return SystemInfo.isWindows ? "catalina.bat" : "catalina.sh";
    }

    private static void setupJavaPath(List<EnvironmentVariable> vars, String varName, String jrePath) {
        if (jrePath != null) {
            vars.add(new EnvironmentVariable(varName, jrePath, true));
        } else {
            String envValue = EnvironmentUtil.getValue((String)varName);
            if (envValue != null) {
                vars.add(new EnvironmentVariable(varName, envValue, true));
            }
        }
    }

    private static class ExecutableCreator {
        private final TomcatLocalModel myTomcatModel;
        private final File myBinDir;
        private final File myCatalinaScriptFile;
        private final String myScriptCommand;
        private final String myJavaCommand;

        public ExecutableCreator(TomcatLocalModel model, @NonNls String scriptCommand, @NonNls String javaCommand) throws RuntimeConfigurationException {
            this.myScriptCommand = scriptCommand;
            this.myJavaCommand = javaCommand;
            this.myTomcatModel = model;
            this.myBinDir = new File(new File(this.myTomcatModel.getHomeDirectory()), TomcatStartupPolicy.BIN_DIR);
            this.myCatalinaScriptFile = new File(this.myBinDir, TomcatStartupPolicy.getDefaultCatalinaFileName());
        }

        protected final TomcatLocalModel getTomcatModel() {
            return this.myTomcatModel;
        }

        public ExecutableObject createExecutable() throws RuntimeConfigurationException {
            if (this.myCatalinaScriptFile.exists()) {
                return this.createScriptExecutable();
            }
            return this.createJavaExecutable();
        }

        private ExecutableObject createScriptExecutable() {
            return new ColoredCommandLineExecutableObject(new String[]{this.myCatalinaScriptFile.getAbsolutePath(), this.myScriptCommand}, null){

                public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
                    List<String> customJavaOptions = this.getCustomJavaOptions();
                    if (!customJavaOptions.isEmpty()) {
                        envVariables = new HashMap(envVariables);
                        String javaOptions = StringUtil.notNullize((String)((String)envVariables.get(TomcatStartupPolicy.JAVA_VM_ENV_VARIABLE))) + " " + StringUtil.join(customJavaOptions, (String)" ");
                        envVariables.put(TomcatStartupPolicy.JAVA_VM_ENV_VARIABLE, javaOptions);
                    }
                    return super.createProcessHandler(workingDirectory, envVariables);
                }
            };
        }

        private ExecutableObject createJavaExecutable() throws RuntimeConfigurationException {
            Sdk jre = this.getTomcatModel().getJre();
            String vmExecutablePath = jre == null ? "java" : ((JavaSdkType)jre.getSdkType()).getVMExecutablePath(jre);
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(vmExecutablePath, "-Dcatalina.base=" + this.myTomcatModel.getBaseDirectoryPath(), "-Dcatalina.home=" + this.myTomcatModel.getHomeDirectory(), "-Djava.io.tmpdir=" + TomcatStartupPolicy.getCatalinaTempDirectory(this.myTomcatModel)));
            args.addAll(this.getCustomJavaOptions());
            String bootstrapJarPath = new File(this.myBinDir, "bootstrap.jar").getAbsolutePath();
            if (this.myTomcatModel.isVersion7OrHigher()) {
                args.addAll(Arrays.asList(TomcatStartupPolicy.CLASSPATH_PARAMETER, bootstrapJarPath + File.pathSeparator + new File(this.myBinDir, "tomcat-juli.jar").getAbsolutePath(), "org.apache.catalina.startup.Bootstrap"));
            } else {
                args.addAll(Arrays.asList(TomcatStartupPolicy.JAR_PARAMETER, bootstrapJarPath));
            }
            return new ColoredCommandLineExecutableObject(ArrayUtil.toStringArray(args), this.myJavaCommand){

                protected GeneralCommandLine createCommandLine(String[] parameters, Map<String, String> envVariables) {
                    String javaOptions = envVariables.get(TomcatStartupPolicy.JAVA_VM_ENV_VARIABLE);
                    if (javaOptions != null) {
                        ArrayList<String> newParameters = new ArrayList<String>();
                        for (String parameter : parameters) {
                            if (TomcatStartupPolicy.JAR_PARAMETER.equals(parameter) || TomcatStartupPolicy.CLASSPATH_PARAMETER.equals(parameter)) {
                                newParameters.addAll(StringUtil.splitHonorQuotes((String)javaOptions, (char)' '));
                            }
                            newParameters.add(parameter);
                        }
                        parameters = ArrayUtil.toStringArray(newParameters);
                    }
                    return super.createCommandLine(parameters, envVariables);
                }
            };
        }

        protected List<String> getCustomJavaOptions() {
            return Collections.emptyList();
        }
    }
}

