/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.agent;

import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.JMException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.CredentialException;

public abstract class Glassfish3AgentBase
extends SimpleAgentBase {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String SPLIT_PATTERN = "[\\r\\n]+";
    private static final String UTF8 = "UTF-8";
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("(\\S+)\\s+<.*>.*");

    protected boolean doConnect() throws IOException, JMException, SimpleAgentException {
        return this.invoke("version").length > 0;
    }

    public void destroy() {
    }

    protected void doDeploy(String deploymentName, File source, ParametersMap deployParameters) throws IOException, JMException, SimpleAgentException {
        String virtualServer;
        StringBuilder command = new StringBuilder("deploy?force=true");
        String deployTarget = (String)deployParameters.get((Object)"deploy.target");
        if (deployTarget != null) {
            command.append("&target=");
            command.append(deployTarget);
        }
        if (Boolean.parseBoolean((String)deployParameters.get((Object)"specify.name"))) {
            command.append("&name=");
            command.append(deploymentName);
        }
        boolean keepSessions = Boolean.parseBoolean((String)deployParameters.get((Object)"keep.sessions"));
        boolean compatibility = Boolean.parseBoolean((String)deployParameters.get((Object)"compatibility"));
        if (keepSessions || compatibility) {
            command.append("&properties=");
            if (keepSessions) {
                command.append(URLEncoder.encode("keepSessions=true", UTF8));
            }
            if (compatibility && keepSessions) {
                command.append(":");
            }
            if (compatibility) {
                command.append(URLEncoder.encode("compatibility=v2", UTF8));
            }
        }
        if (!Boolean.parseBoolean((String)deployParameters.get((Object)"is.default.context.root"))) {
            command.append("&contextroot=");
            command.append((String)deployParameters.get((Object)"context.root"));
        }
        if ((virtualServer = (String)this.getInitParameters().get((Object)"virtual.server")) != null) {
            command.append("&virtualservers=");
            command.append(virtualServer);
        }
        command.append("&path=");
        if (Boolean.parseBoolean((String)deployParameters.get((Object)"use.glassfish.upload"))) {
            command.append(URLEncoder.encode(source.getName(), UTF8));
            this.invoke(command.toString(), source);
        } else {
            command.append(URLEncoder.encode((String)deployParameters.get((Object)"source.path"), UTF8));
            this.invoke(command.toString());
        }
    }

    protected void doUndeploy(String deploymentName) throws IOException, JMException, SimpleAgentException {
        this.invoke(this.createGetCommand("undeploy", Arrays.asList("DEFAULT=" + URLEncoder.encode(deploymentName, UTF8))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doIsDeployed(String deploymentName) throws IOException, JMException, SimpleAgentException {
        StringBuilder debugMsg = new StringBuilder();
        try {
            debugMsg.append("getDeploymentStatus of: ");
            debugMsg.append(deploymentName);
            debugMsg.append("\n deployed components:\n");
            for (String component : this.invoke(this.createGetCommand("list-components", Collections.<String>emptyList()))) {
                debugMsg.append(component);
                debugMsg.append("\n");
                Matcher componentMatcher = COMPONENT_PATTERN.matcher(component);
                if (!componentMatcher.matches() || !deploymentName.equals(componentMatcher.group(1))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getLog().debug(debugMsg.toString());
        }
    }

    protected String createGetCommand(String command, List<String> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(command);
        ListIterator<String> listIterator = parameters.listIterator();
        while (listIterator.hasNext()) {
            result.append(listIterator.hasPrevious() ? "&" : "?");
            result.append(listIterator.next());
        }
        return result.toString();
    }

    private SSLSocketFactory createSSLSocketFactory() throws SimpleAgentException {
        SSLContext cntxt;
        if (!Boolean.parseBoolean((String)this.getInitParameters().get((Object)"is.secured"))) {
            return null;
        }
        try {
            cntxt = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SimpleAgentException((Exception)e);
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            cntxt.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            throw new SimpleAgentException((Exception)e);
        }
        return cntxt.getSocketFactory();
    }

    private String[] invoke(String command) throws IOException, SimpleAgentException {
        try {
            HttpURLConnection connection = this.getConnection(command, "GET", this.createSSLSocketFactory());
            connection.connect();
            return this.parseResponse(connection);
        }
        catch (CredentialException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] invoke(String command, File file) throws IOException, SimpleAgentException {
        try {
            HttpURLConnection connection = this.getConnection(command, "POST", this.createSSLSocketFactory());
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/zip");
            connection.setChunkedStreamingMode(0);
            connection.connect();
            ZipOutputStream zip = new ZipOutputStream(connection.getOutputStream());
            ZipEntry entry = new ZipEntry(file.getName());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Properties properties = new Properties();
            properties.setProperty("Content-Type", "application/octet-stream");
            properties.setProperty("data-request-type", "file-xfer");
            properties.setProperty("data-request-name", "path");
            properties.setProperty("last-modified", Long.toString(file.lastModified()));
            properties.store(out, null);
            entry.setExtra(out.toByteArray());
            zip.putNextEntry(entry);
            BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));
            try {
                Glassfish3AgentBase.copy(fileStream, zip);
            }
            finally {
                ((InputStream)fileStream).close();
            }
            zip.closeEntry();
            return this.parseResponse(connection);
        }
        catch (CredentialException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    private String[] parseResponse(HttpURLConnection connection) throws IOException, CredentialException {
        if (connection.getResponseCode() == 401) {
            throw new CredentialException();
        }
        return this.doParseResponse(connection);
    }

    protected abstract String[] doParseResponse(HttpURLConnection var1) throws IOException;

    protected abstract HttpURLConnection getConnection(String var1, String var2, SSLSocketFactory var3) throws IOException;
}

