/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.hibernate.remote.RemoteConfiguration;
import com.intellij.hibernate.remote.impl.BaseHibernateFacade;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;

public abstract class RemoteConfigurationImpl
extends JdbcRemoteObject
implements RemoteConfiguration {
    private final Configuration myDelegate;

    public RemoteConfigurationImpl(Configuration delegate) {
        this.myDelegate = delegate;
    }

    public Configuration getDelegate() {
        return this.myDelegate;
    }

    public void setProperty(String p1, String p2) throws RemoteException {
        try {
            this.myDelegate.setProperty(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public String getProperty(String p1) throws RemoteException {
        try {
            return this.myDelegate.getProperty(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public Properties getProperties() throws RemoteException {
        try {
            return this.myDelegate.getProperties();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setProperties(Properties p1) throws RemoteException {
        try {
            this.myDelegate.setProperties(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void configure(String p1) throws RemoteException {
        try {
            this.myDelegate.configure(new File(p1));
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void configure() throws RemoteException {
        try {
            this.myDelegate.configure();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addFile(String p1) throws RemoteException {
        try {
            this.myDelegate.addFile(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addProperties(Properties p1) throws RemoteException {
        try {
            this.myDelegate.addProperties(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public Map getImports() throws RemoteException {
        try {
            return this.myDelegate.getImports();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addCacheableFile(String p1) throws RemoteException {
        try {
            this.myDelegate.addCacheableFile(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addXML(String p1) throws RemoteException {
        try {
            this.myDelegate.addXML(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addResource(String p1) throws RemoteException {
        try {
            this.myDelegate.addResource(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void addResource(String p1, ClassLoader p2) throws RemoteException {
        try {
            this.myDelegate.addResource(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void buildMappings() throws RemoteException {
        try {
            this.myDelegate.buildMappings();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void mergeProperties(Properties p1) throws RemoteException {
        try {
            this.myDelegate.mergeProperties(p1);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setCacheConcurrencyStrategy(String p1, String p2, String p3) throws RemoteException {
        try {
            this.myDelegate.setCacheConcurrencyStrategy(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setCacheConcurrencyStrategy(String p1, String p2) throws RemoteException {
        try {
            this.myDelegate.setCacheConcurrencyStrategy(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setCollectionCacheConcurrencyStrategy(String p1, String p2) throws RemoteException {
        try {
            this.myDelegate.setCollectionCacheConcurrencyStrategy(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void setCollectionCacheConcurrencyStrategy(String p1, String p2, String p3) throws RemoteException {
        try {
            this.myDelegate.setCollectionCacheConcurrencyStrategy(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public String generateSchemaCreationScript() throws RemoteException {
        try {
            return this.generateDDLInner(false);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public String generateDropSchemaScript() throws RemoteException {
        try {
            return this.generateDDLInner(true);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    private String generateDDLInner(boolean drop) {
        Dialect dialect = Dialect.getDialect((Properties)this.myDelegate.getProperties());
        String[] ddl = drop ? this.myDelegate.generateDropSchemaScript(dialect) : this.myDelegate.generateSchemaCreationScript(dialect);
        StringBuilder sb = new StringBuilder();
        for (String sql : ddl) {
            sb.append(this.getFormatter().formatDDL(sql)).append(";\n");
        }
        return sb.toString();
    }

    protected abstract BaseHibernateFacade.Formatter getFormatter();

    public void setNamingStrategy(String p1) throws RemoteException {
        try {
            this.myDelegate.setNamingStrategy((NamingStrategy)Class.forName(p1).newInstance());
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }
}

