/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.javaee;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javascript.debugger.execution.BaseJavaScriptDebuggerStarter;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEEJavaScriptDebugStarter
extends BaseJavaScriptDebuggerStarter<CommonModel, J2EEServerInstance> {
    public boolean isApplicable(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/debugger/javaee/JavaEEJavaScriptDebugStarter", "isApplicable"));
        }
        return runConfiguration instanceof CommonModel;
    }

    @Nullable
    protected List<RemoteUrlMappingBean> createMappings(@NotNull String url, @NotNull CommonModel runConfiguration, @NotNull J2EEServerInstance serverInstance, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/javaee/JavaEEJavaScriptDebugStarter", "createMappings"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/debugger/javaee/JavaEEJavaScriptDebugStarter", "createMappings"));
        }
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javascript/debugger/javaee/JavaEEJavaScriptDebugStarter", "createMappings"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/javaee/JavaEEJavaScriptDebugStarter", "createMappings"));
        }
        SmartList mappings = new SmartList();
        Map<VirtualFile, String> webRootUrls = JavaEEJavaScriptDebugStarter.getWebRootMappings(runConfiguration, serverInstance, project);
        for (Map.Entry<VirtualFile, String> entry : webRootUrls.entrySet()) {
            mappings.add(new RemoteUrlMappingBean(entry.getKey().getPath(), entry.getValue()));
        }
        return mappings;
    }

    private static Map<VirtualFile, String> getWebRootMappings(CommonModel runConfiguration, J2EEServerInstance serverInstance, Project project) {
        AppServerDeployedFileUrlProvider urlProvider = serverInstance.getIntegration().getDeployedFileUrlProvider();
        HashMap<VirtualFile, String> webRootUrls = new HashMap<VirtualFile, String>();
        for (DeploymentModel deploymentModel : runConfiguration.getDeploymentModels()) {
            Artifact artifact = deploymentModel.getArtifact();
            if (artifact == null) continue;
            Collection webFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, WebFacet.ID);
            for (WebFacet webFacet : webFacets) {
                String webRootUrl = urlProvider instanceof ApplicationServerUrlMapping ? ((ApplicationServerUrlMapping)urlProvider).getUrlForDeployedFile(serverInstance, deploymentModel, (JavaeeFacet)webFacet, "/") : urlProvider.getUrlForDeployedFile(serverInstance, deploymentModel, "/");
                if (webRootUrl == null) continue;
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    VirtualFile rootFile = webRoot.getFile();
                    if (rootFile == null) continue;
                    webRootUrls.put(rootFile, webRootUrl);
                }
            }
        }
        return webRootUrls;
    }
}

