/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.websocket.jam.SpringMessageMapping;
import com.intellij.spring.websocket.jam.SpringMessagingUrlAnnotation;
import com.intellij.spring.websocket.jam.SpringSendTo;
import com.intellij.spring.websocket.jam.SpringSendToUser;
import com.intellij.spring.websocket.jam.SpringSubscribeMapping;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMessagingJamModel {
    @NotNull
    private final Project myProject;

    public static SpringMessagingJamModel getModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getModel"));
        }
        return (SpringMessagingJamModel)ServiceManager.getService((Project)project, SpringMessagingJamModel.class);
    }

    public SpringMessagingJamModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<SpringMessageMapping.MethodMapping> getMessageMappings(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getMessageMappings"));
        }
        List<SpringMessageMapping.MethodMapping> list = this.getAnnotations(module, SpringMessageMapping.MethodMapping.META, "org.springframework.messaging.handler.annotation.MessageMapping");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getMessageMappings"));
        }
        return list;
    }

    @NotNull
    public List<SpringSubscribeMapping> getSubscribeMappings(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSubscribeMappings"));
        }
        List<SpringSubscribeMapping> list = this.getAnnotations(module, SpringSubscribeMapping.META, "org.springframework.messaging.simp.annotation.SubscribeMapping");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSubscribeMappings"));
        }
        return list;
    }

    @NotNull
    public List<SpringSendTo> getSendTos(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSendTos"));
        }
        List<SpringSendTo> list = this.getAnnotations(module, SpringSendTo.META, "org.springframework.messaging.handler.annotation.SendTo");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSendTos"));
        }
        return list;
    }

    @NotNull
    public List<SpringSendToUser> getSendToUsers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSendToUsers"));
        }
        List<SpringSendToUser> list = this.getAnnotations(module, SpringSendToUser.META, "org.springframework.messaging.simp.annotation.SendToUser");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getSendToUsers"));
        }
        return list;
    }

    @NotNull
    private <T extends SpringMessagingUrlAnnotation<PsiMethod>> List<T> getAnnotations(@NotNull Module module, @NotNull JamMethodMeta<T> meta, @NotNull String annotation) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getAnnotations"));
        }
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getAnnotations"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getAnnotations"));
        }
        JamService service = JamService.getJamService((Project)this.myProject);
        List list = service.getJamMethodElements(meta, annotation, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingJamModel", "getAnnotations"));
        }
        return list;
    }
}

