/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathResult;

public class XPathResultImpl
implements XPathResult {
    private final long peer;
    public static final int ANY_TYPE = 0;
    public static final int NUMBER_TYPE = 1;
    public static final int STRING_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    public static final int UNORDERED_NODE_ITERATOR_TYPE = 4;
    public static final int ORDERED_NODE_ITERATOR_TYPE = 5;
    public static final int UNORDERED_NODE_SNAPSHOT_TYPE = 6;
    public static final int ORDERED_NODE_SNAPSHOT_TYPE = 7;
    public static final int ANY_UNORDERED_NODE_TYPE = 8;
    public static final int FIRST_ORDERED_NODE_TYPE = 9;

    XPathResultImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static XPathResult create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new XPathResultImpl(peer);
    }

    long getPeer() {
        return this.peer;
    }

    public boolean equals(Object that) {
        return that instanceof XPathResultImpl && this.peer == ((XPathResultImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    static long getPeer(XPathResult arg) {
        return arg == null ? 0L : ((XPathResultImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static XPathResult getImpl(long peer) {
        return XPathResultImpl.create(peer);
    }

    @Override
    public short getResultType() {
        return XPathResultImpl.getResultTypeImpl(this.getPeer());
    }

    static native short getResultTypeImpl(long var0);

    @Override
    public double getNumberValue() throws DOMException {
        return XPathResultImpl.getNumberValueImpl(this.getPeer());
    }

    static native double getNumberValueImpl(long var0);

    @Override
    public String getStringValue() throws DOMException {
        return XPathResultImpl.getStringValueImpl(this.getPeer());
    }

    static native String getStringValueImpl(long var0);

    @Override
    public boolean getBooleanValue() throws DOMException {
        return XPathResultImpl.getBooleanValueImpl(this.getPeer());
    }

    static native boolean getBooleanValueImpl(long var0);

    @Override
    public Node getSingleNodeValue() throws DOMException {
        return NodeImpl.getImpl(XPathResultImpl.getSingleNodeValueImpl(this.getPeer()));
    }

    static native long getSingleNodeValueImpl(long var0);

    @Override
    public boolean getInvalidIteratorState() {
        return XPathResultImpl.getInvalidIteratorStateImpl(this.getPeer());
    }

    static native boolean getInvalidIteratorStateImpl(long var0);

    @Override
    public int getSnapshotLength() throws DOMException {
        return XPathResultImpl.getSnapshotLengthImpl(this.getPeer());
    }

    static native int getSnapshotLengthImpl(long var0);

    @Override
    public Node iterateNext() throws DOMException {
        return NodeImpl.getImpl(XPathResultImpl.iterateNextImpl(this.getPeer()));
    }

    static native long iterateNextImpl(long var0);

    @Override
    public Node snapshotItem(int index) throws DOMException {
        return NodeImpl.getImpl(XPathResultImpl.snapshotItemImpl(this.getPeer(), index));
    }

    static native long snapshotItemImpl(long var0, int var2);

    private static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            XPathResultImpl.dispose(this.peer);
        }
    }
}

