/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import com.sun.scenario.effect.impl.state.RenderState;

public class PerspectiveTransform
extends CoreEffect<RenderState> {
    private float[][] tx = new float[3][3];
    private float ulx;
    private float uly;
    private float urx;
    private float ury;
    private float lrx;
    private float lry;
    private float llx;
    private float lly;
    private float[] devcoords = new float[8];
    private final PerspectiveTransformState state = new PerspectiveTransformState();

    public PerspectiveTransform() {
        this(DefaultInput);
    }

    public PerspectiveTransform(Effect input) {
        super(input);
        this.setQuadMapping(0.0f, 0.0f, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
        this.updatePeerKey("PerspectiveTransform");
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    private void setUnitQuadMapping(float ulx, float uly, float urx, float ury, float lrx, float lry, float llx, float lly) {
        float dx3 = ulx - urx + lrx - llx;
        float dy3 = uly - ury + lry - lly;
        this.tx[2][2] = 1.0f;
        if (dx3 == 0.0f && dy3 == 0.0f) {
            this.tx[0][0] = urx - ulx;
            this.tx[0][1] = lrx - urx;
            this.tx[0][2] = ulx;
            this.tx[1][0] = ury - uly;
            this.tx[1][1] = lry - ury;
            this.tx[1][2] = uly;
            this.tx[2][0] = 0.0f;
            this.tx[2][1] = 0.0f;
        } else {
            float dx1 = urx - lrx;
            float dy1 = ury - lry;
            float dx2 = llx - lrx;
            float dy2 = lly - lry;
            float invdet = 1.0f / (dx1 * dy2 - dx2 * dy1);
            this.tx[2][0] = (dx3 * dy2 - dx2 * dy3) * invdet;
            this.tx[2][1] = (dx1 * dy3 - dx3 * dy1) * invdet;
            this.tx[0][0] = urx - ulx + this.tx[2][0] * urx;
            this.tx[0][1] = llx - ulx + this.tx[2][1] * llx;
            this.tx[0][2] = ulx;
            this.tx[1][0] = ury - uly + this.tx[2][0] * ury;
            this.tx[1][1] = lly - uly + this.tx[2][1] * lly;
            this.tx[1][2] = uly;
        }
        this.state.updateTx(this.tx);
    }

    public final void setQuadMapping(float ulx, float uly, float urx, float ury, float lrx, float lry, float llx, float lly) {
        this.ulx = ulx;
        this.uly = uly;
        this.urx = urx;
        this.ury = ury;
        this.lrx = lrx;
        this.lry = lry;
        this.llx = llx;
        this.lly = lly;
    }

    @Override
    public RectBounds getBounds(BaseTransform transform, Effect defaultInput) {
        float maxy;
        float maxx;
        this.setupDevCoords(transform);
        float minx = maxx = this.devcoords[0];
        float miny = maxy = this.devcoords[1];
        for (int i = 2; i < this.devcoords.length; i += 2) {
            if (minx > this.devcoords[i]) {
                minx = this.devcoords[i];
            } else if (maxx < this.devcoords[i]) {
                maxx = this.devcoords[i];
            }
            if (miny > this.devcoords[i + 1]) {
                miny = this.devcoords[i + 1];
                continue;
            }
            if (!(maxy < this.devcoords[i + 1])) continue;
            maxy = this.devcoords[i + 1];
        }
        return new RectBounds(minx, miny, maxx, maxy);
    }

    private void setupDevCoords(BaseTransform transform) {
        this.devcoords[0] = this.ulx;
        this.devcoords[1] = this.uly;
        this.devcoords[2] = this.urx;
        this.devcoords[3] = this.ury;
        this.devcoords[4] = this.lrx;
        this.devcoords[5] = this.lry;
        this.devcoords[6] = this.llx;
        this.devcoords[7] = this.lly;
        transform.transform(this.devcoords, 0, this.devcoords, 0, 4);
    }

    @Override
    public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        this.setupTransforms(transform);
        RenderState rstate = this.getRenderState(fctx, transform, outputClip, renderHelper, defaultInput);
        Effect input = this.getDefaultedInput(0, defaultInput);
        Rectangle inputClip = rstate.getInputClip(0, outputClip);
        ImageData inputData = input.filter(fctx, BaseTransform.IDENTITY_TRANSFORM, inputClip, null, defaultInput);
        if (!inputData.validate(fctx)) {
            inputData.unref();
            return new ImageData(fctx, null, inputData.getUntransformedBounds());
        }
        ImageData ret = this.filterImageDatas(fctx, transform, outputClip, rstate, new ImageData[]{inputData});
        inputData.unref();
        return ret;
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        Rectangle ob = new Rectangle(this.getBounds(transform, null));
        ob.intersectWith(outputClip);
        return ob;
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        this.setupTransforms(BaseTransform.IDENTITY_TRANSFORM);
        Effect input = this.getDefaultedInput(0, defaultInput);
        p = input.transform(p, defaultInput);
        BaseBounds b = input.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        float sx = (p.x - b.getMinX()) / b.getWidth();
        float sy = (p.y - b.getMinY()) / b.getHeight();
        float dx = this.tx[0][0] * sx + this.tx[0][1] * sy + this.tx[0][2];
        float dy = this.tx[1][0] * sx + this.tx[1][1] * sy + this.tx[1][2];
        float dw = this.tx[2][0] * sx + this.tx[2][1] * sy + this.tx[2][2];
        p = new Point2D(dx / dw, dy / dw);
        return p;
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        this.setupTransforms(BaseTransform.IDENTITY_TRANSFORM);
        Effect input = this.getDefaultedInput(0, defaultInput);
        float dx = p.x;
        float dy = p.y;
        float[][] itx = this.state.getITX();
        float sx = itx[0][0] * dx + itx[0][1] * dy + itx[0][2];
        float sy = itx[1][0] * dx + itx[1][1] * dy + itx[1][2];
        float sw = itx[2][0] * dx + itx[2][1] * dy + itx[2][2];
        BaseBounds b = input.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        p = new Point2D(b.getMinX() + sx / sw * b.getWidth(), b.getMinY() + sy / sw * b.getHeight());
        p = this.getDefaultedInput(0, defaultInput).untransform(p, defaultInput);
        return p;
    }

    private void setupTransforms(BaseTransform transform) {
        this.setupDevCoords(transform);
        this.setUnitQuadMapping(this.devcoords[0], this.devcoords[1], this.devcoords[2], this.devcoords[3], this.devcoords[4], this.devcoords[5], this.devcoords[6], this.devcoords[7]);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return RenderState.UnclippedUserSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        DirtyRegionContainer drc = regionPool.checkOut();
        drc.deriveWithNewRegion(this.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput));
        return drc;
    }
}

