/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.LinearConvolveCoreEffect;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxBlurState;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;

public class BoxBlur
extends LinearConvolveCoreEffect {
    private final BoxBlurState state = new BoxBlurState();

    public BoxBlur() {
        this(1, 1);
    }

    public BoxBlur(int hsize, int vsize) {
        this(hsize, vsize, 1, DefaultInput);
    }

    public BoxBlur(int hsize, int vsize, int passes) {
        this(hsize, vsize, passes, DefaultInput);
    }

    public BoxBlur(int hsize, int vsize, int passes, Effect input) {
        super(input);
        this.setHorizontalSize(hsize);
        this.setVerticalSize(vsize);
        this.setPasses(passes);
    }

    @Override
    LinearConvolveKernel getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getHorizontalSize() {
        return this.state.getHsize();
    }

    public final void setHorizontalSize(int hsize) {
        this.state.setHsize(hsize);
    }

    public int getVerticalSize() {
        return this.state.getVsize();
    }

    public final void setVerticalSize(int vsize) {
        this.state.setVsize(vsize);
    }

    public int getPasses() {
        return this.state.getBlurPasses();
    }

    public final void setPasses(int passes) {
        this.state.setBlurPasses(passes);
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return Renderer.getRenderer(fctx).getAccelType();
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseBounds r = super.getBounds(null, defaultInput);
        int hgrow = this.state.getKernelSize(0) / 2;
        int vgrow = this.state.getKernelSize(1) / 2;
        RectBounds ret = new RectBounds(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
        ret.grow(hgrow, vgrow);
        return BoxBlur.transformBounds(transform, ret);
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        Rectangle r = inputDatas[0].getTransformedBounds(null);
        r = this.state.getResultBounds(r, 0);
        r = this.state.getResultBounds(r, 1);
        r.intersectWith(outputClip);
        return r;
    }

    @Override
    public boolean reducesOpaquePixels() {
        if (!this.state.isNop()) {
            return true;
        }
        Effect input = this.getInput();
        return input != null && input.reducesOpaquePixels();
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        drc.grow(this.state.getKernelSize(0) / 2, this.state.getKernelSize(1) / 2);
        return drc;
    }
}

