/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.TickCalculation;
import javafx.animation.Interpolator;
import javafx.util.Duration;

public class NumberTangentInterpolator
extends Interpolator {
    private final double inValue;
    private final double outValue;
    private final long inTicks;
    private final long outTicks;

    public double getInValue() {
        return this.inValue;
    }

    public double getOutValue() {
        return this.outValue;
    }

    public double getInTicks() {
        return this.inTicks;
    }

    public double getOutTicks() {
        return this.outTicks;
    }

    public NumberTangentInterpolator(Duration inDuration, double inValue, Duration outDuration, double outValue) {
        this.inTicks = TickCalculation.fromDuration(inDuration);
        this.inValue = inValue;
        this.outTicks = TickCalculation.fromDuration(outDuration);
        this.outValue = outValue;
    }

    public NumberTangentInterpolator(Duration duration, double value) {
        this.outTicks = this.inTicks = TickCalculation.fromDuration(duration);
        this.inValue = this.outValue = value;
    }

    public String toString() {
        return "NumberTangentInterpolator [inValue=" + this.inValue + ", inDuration=" + TickCalculation.toDuration(this.inTicks) + ", outValue=" + this.outValue + ", outDuration=" + TickCalculation.toDuration(this.outTicks) + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.inValue) ^ Double.doubleToLongBits(this.inValue) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.outValue) ^ Double.doubleToLongBits(this.outValue) >>> 32);
        hash = 59 * hash + (int)(this.inTicks ^ this.inTicks >>> 32);
        hash = 59 * hash + (int)(this.outTicks ^ this.outTicks >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberTangentInterpolator other = (NumberTangentInterpolator)obj;
        if (Double.doubleToLongBits(this.inValue) != Double.doubleToLongBits(other.inValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.outValue) != Double.doubleToLongBits(other.outValue)) {
            return false;
        }
        if (this.inTicks != other.inTicks) {
            return false;
        }
        return this.outTicks == other.outTicks;
    }

    @Override
    protected double curve(double t) {
        return t;
    }
}

