/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPathIterator;
import com.sun.webkit.graphics.WCRectangle;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WCPathImpl
extends WCPath<Path2D> {
    private final Path2D path;
    private boolean hasCP = false;
    private static final Logger log = Logger.getLogger(WCPathImpl.class.getName());

    WCPathImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create empty WCPathImpl({0})", this.getID());
        }
        this.path = new Path2D();
    }

    WCPathImpl(WCPathImpl wcp) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create WCPathImpl({0}) from WCPathImpl({1})", new Object[]{this.getID(), wcp.getID()});
        }
        this.path = new Path2D(wcp.path);
        this.hasCP = wcp.hasCP;
    }

    @Override
    public void addRect(double x, double y, double w, double h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addRect({1},{2},{3},{4})", new Object[]{this.getID(), x, y, w, h});
        }
        this.hasCP = true;
        this.path.append(new RoundRectangle2D((float)x, (float)y, (float)w, (int)h, 0.0f, 0.0f), false);
    }

    @Override
    public void addEllipse(double x, double y, double w, double h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addEllipse({1},{2},{3},{4})", new Object[]{this.getID(), x, y, w, h});
        }
        this.hasCP = true;
        this.path.append(new Ellipse2D((float)x, (float)y, (float)w, (float)h), false);
    }

    @Override
    public void addArcTo(double x1, double y1, double x2, double y2, double r) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArcTo({1},{2},{3},{4})", new Object[]{this.getID(), x1, y1, x2, y2});
        }
        Arc2D arc = new Arc2D();
        arc.setArcByTangent(this.path.getCurrentPoint(), new Point2D((float)x1, (float)y1), new Point2D((float)x2, (float)y2), (float)r);
        this.hasCP = true;
        this.path.append(arc, true);
    }

    @Override
    public void addArc(double x, double y, double r, double startAngle, double endAngle, boolean aclockwise) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArc({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), x, y, r, startAngle, endAngle, aclockwise});
        }
        this.hasCP = true;
        double eps = 0.001;
        if (!aclockwise) {
            int sMult;
            int eMult;
            if (endAngle < 0.0) {
                if (endAngle < Math.PI * -2 - eps) {
                    eMult = (int)(-endAngle / (Math.PI * 2));
                    endAngle += (double)eMult * 2.0 * Math.PI;
                }
                endAngle += Math.PI * 2;
            } else if (endAngle > Math.PI * 2 + eps) {
                eMult = (int)(endAngle / (Math.PI * 2));
                endAngle -= (double)eMult * 2.0 * Math.PI;
            }
            if (startAngle < 0.0) {
                if (startAngle < Math.PI * -2 - eps) {
                    sMult = (int)(-startAngle / (Math.PI * 2));
                    startAngle += (double)sMult * 2.0 * Math.PI;
                }
                startAngle += Math.PI * 2;
            } else if (startAngle > Math.PI * 2 + eps) {
                sMult = (int)(startAngle / (Math.PI * 2));
                startAngle -= (double)sMult * 2.0 * Math.PI;
            }
            double d = startAngle - endAngle;
            if (startAngle < endAngle) {
                d = Math.abs(d);
            }
            endAngle = (float)(Math.PI * 2 - endAngle);
            Arc2D arc = new Arc2D((float)(x - r), (float)(y - r), (float)(2.0 * r), (float)(2.0 * r), (float)(endAngle * 180.0 / Math.PI), (float)(d * 180.0 / Math.PI), 0);
            PathIterator pi = ((Shape)arc).getPathIterator(null);
            ArrayList<Integer> segStack = new ArrayList<Integer>();
            ArrayList<Float> valStack = new ArrayList<Float>();
            float[] coords = new float[6];
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        valStack.add(Float.valueOf(coords[1]));
                        valStack.add(Float.valueOf(coords[0]));
                        break;
                    }
                    case 2: {
                        throw new RuntimeException("Unexpected segment: SEG_QUADTO");
                    }
                    case 3: {
                        valStack.add(Float.valueOf(coords[1]));
                        valStack.add(Float.valueOf(coords[0]));
                        valStack.add(Float.valueOf(coords[3]));
                        valStack.add(Float.valueOf(coords[2]));
                        valStack.add(Float.valueOf(coords[5]));
                        valStack.add(Float.valueOf(coords[4]));
                        segStack.add(3);
                        break;
                    }
                    case 4: {
                        throw new RuntimeException("Unexpected segment: SEG_CLOSE");
                    }
                }
                pi.next();
            }
            segStack.add(0);
            Path2D invArc = new Path2D();
            int segIndex = segStack.size();
            int valIndex = valStack.size();
            while (segIndex > 0) {
                switch ((Integer)segStack.get(--segIndex)) {
                    case 0: {
                        invArc.moveTo(((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue());
                        break;
                    }
                    case 1: {
                        invArc.lineTo(((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue());
                        break;
                    }
                    case 2: {
                        invArc.quadTo(((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue());
                        break;
                    }
                    case 3: {
                        invArc.curveTo(((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue(), ((Float)valStack.get(--valIndex)).floatValue());
                    }
                }
            }
            this.path.append(invArc, true);
        } else {
            int sMult;
            int eMult;
            if (endAngle < 0.0) {
                if (endAngle < Math.PI * -2 - eps) {
                    eMult = (int)(-endAngle / (Math.PI * 2));
                    endAngle += (double)eMult * 2.0 * Math.PI;
                }
                endAngle += Math.PI * 2;
            } else if (endAngle > Math.PI * 2 + eps) {
                eMult = (int)(endAngle / (Math.PI * 2));
                endAngle -= (double)eMult * 2.0 * Math.PI;
            }
            if (startAngle < 0.0) {
                if (startAngle < Math.PI * -2 - eps) {
                    sMult = (int)(-startAngle / (Math.PI * 2));
                    startAngle += (double)sMult * 2.0 * Math.PI;
                }
                startAngle += Math.PI * 2;
            } else if (startAngle > Math.PI * 2 + eps) {
                sMult = (int)(startAngle / (Math.PI * 2));
                startAngle -= (double)sMult * 2.0 * Math.PI;
            }
            double d = startAngle - endAngle;
            if (startAngle < endAngle && (d += Math.PI * 2) < eps) {
                d += Math.PI * 2;
            }
            if (Math.abs(startAngle) > eps) {
                startAngle = (float)(Math.PI * 2 - startAngle);
            }
            this.path.append(new Arc2D((float)(x - r), (float)(y - r), (float)(2.0 * r), (float)(2.0 * r), (float)(startAngle * 180.0 / Math.PI), (float)(d * 180.0 / Math.PI), 0), true);
        }
    }

    @Override
    public boolean contains(int rule, double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).contains({1},{2},{3})", new Object[]{this.getID(), rule, x, y});
        }
        int savedRule = this.path.getWindingRule();
        this.path.setWindingRule(rule);
        boolean res = this.path.contains((float)x, (float)y);
        this.path.setWindingRule(savedRule);
        return res;
    }

    @Override
    public WCRectangle getBounds() {
        RectBounds b = this.path.getBounds();
        return new WCRectangle(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public void clear() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).clear()", this.getID());
        }
        this.hasCP = false;
        this.path.reset();
    }

    @Override
    public void moveTo(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).moveTo({1},{2})", new Object[]{this.getID(), x, y});
        }
        this.hasCP = true;
        this.path.moveTo((float)x, (float)y);
    }

    @Override
    public void addLineTo(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addLineTo({1},{2})", new Object[]{this.getID(), x, y});
        }
        this.hasCP = true;
        this.path.lineTo((float)x, (float)y);
    }

    @Override
    public void addQuadCurveTo(double x0, double y0, double x1, double y1) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addQuadCurveTo({1},{2},{3},{4})", new Object[]{this.getID(), x0, y0, x1, y1});
        }
        this.hasCP = true;
        this.path.quadTo((float)x0, (float)y0, (float)x1, (float)y1);
    }

    @Override
    public void addBezierCurveTo(double x0, double y0, double x1, double y1, double x2, double y2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addBezierCurveTo({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), x0, y0, x1, y1, x2, y2});
        }
        this.hasCP = true;
        this.path.curveTo((float)x0, (float)y0, (float)x1, (float)y1, (float)x2, (float)y2);
    }

    @Override
    public void addPath(WCPath p) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addPath({1})", new Object[]{this.getID(), p.getID()});
        }
        this.hasCP = this.hasCP || ((WCPathImpl)p).hasCP;
        this.path.append(((WCPathImpl)p).path, false);
    }

    @Override
    public void closeSubpath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).closeSubpath()", this.getID());
        }
        this.path.closePath();
    }

    @Override
    public boolean hasCurrentPoint() {
        return this.hasCP;
    }

    @Override
    public boolean isEmpty() {
        PathIterator pi = this.path.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
            }
            pi.next();
        }
        return true;
    }

    @Override
    public int getWindingRule() {
        return 1 - this.path.getWindingRule();
    }

    @Override
    public void setWindingRule(int rule) {
        this.path.setWindingRule(1 - rule);
    }

    @Override
    public Path2D getPlatformPath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).getPath() BEGIN=====", this.getID());
            PathIterator pi = this.path.getPathIterator(null);
            float[] coords = new float[6];
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        log.log(Level.FINE, "SEG_MOVETO ({0},{1})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1])});
                        break;
                    }
                    case 1: {
                        log.log(Level.FINE, "SEG_LINETO ({0},{1})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1])});
                        break;
                    }
                    case 2: {
                        log.log(Level.FINE, "SEG_QUADTO ({0},{1},{2},{3})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1]), Float.valueOf(coords[2]), Float.valueOf(coords[3])});
                        break;
                    }
                    case 3: {
                        log.log(Level.FINE, "SEG_CUBICTO ({0},{1},{2},{3},{4},{5})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1]), Float.valueOf(coords[2]), Float.valueOf(coords[3]), Float.valueOf(coords[4]), Float.valueOf(coords[5])});
                        break;
                    }
                    case 4: {
                        log.fine("SEG_CLOSE");
                    }
                }
                pi.next();
            }
            log.fine("========getPath() END=====");
        }
        return this.path;
    }

    @Override
    public WCPathIterator getPathIterator() {
        final PathIterator pi = this.path.getPathIterator(null);
        return new WCPathIterator(){

            @Override
            public int getWindingRule() {
                return pi.getWindingRule();
            }

            @Override
            public boolean isDone() {
                return pi.isDone();
            }

            @Override
            public void next() {
                pi.next();
            }

            @Override
            public int currentSegment(double[] coords) {
                float[] _coords = new float[6];
                int segmentType = pi.currentSegment(_coords);
                for (int i = 0; i < coords.length; ++i) {
                    coords[i] = _coords[i];
                }
                return segmentType;
            }
        };
    }

    @Override
    public void translate(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).translate({1}, {2})", new Object[]{this.getID(), x, y});
        }
        this.path.transform(BaseTransform.getTranslateInstance(x, y));
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).transform({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), mxx, myx, mxy, myy, mxt, myt});
        }
        this.path.transform(BaseTransform.getInstance(mxx, myx, mxy, myy, mxt, myt));
    }
}

