/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class WeightedClosestCorner
implements Algorithm {
    WeightedClosestCorner() {
    }

    private boolean isOnAxis(Direction dir, Bounds cur, Bounds tgt) {
        double tmax;
        double tmin;
        double cmax;
        double cmin;
        if (dir == Direction.UP || dir == Direction.DOWN) {
            cmin = cur.getMinX();
            cmax = cur.getMaxX();
            tmin = tgt.getMinX();
            tmax = tgt.getMaxX();
        } else {
            cmin = cur.getMinY();
            cmax = cur.getMaxY();
            tmin = tgt.getMinY();
            tmax = tgt.getMaxY();
        }
        return tmin <= cmax && tmax >= cmin;
    }

    private double outDistance(Direction dir, Bounds cur, Bounds tgt) {
        double distance = dir == Direction.UP ? cur.getMinY() - tgt.getMaxY() : (dir == Direction.DOWN ? tgt.getMinY() - cur.getMaxY() : (dir == Direction.LEFT ? cur.getMinX() - tgt.getMaxX() : tgt.getMinX() - cur.getMaxX()));
        return distance;
    }

    private double centerSideDistance(Direction dir, Bounds cur, Bounds tgt) {
        double tc;
        double cc;
        if (dir == Direction.UP || dir == Direction.DOWN) {
            cc = cur.getMinX() + cur.getWidth() / 2.0;
            tc = tgt.getMinX() + tgt.getWidth() / 2.0;
        } else {
            cc = cur.getMinY() + cur.getHeight() / 2.0;
            tc = tgt.getMinY() + tgt.getHeight() / 2.0;
        }
        return Math.abs(tc - cc);
    }

    private double cornerSideDistance(Direction dir, Bounds cur, Bounds tgt) {
        double distance = dir == Direction.UP || dir == Direction.DOWN ? (tgt.getMinX() > cur.getMaxX() ? tgt.getMinX() - cur.getMaxX() : cur.getMinX() - tgt.getMaxX()) : (tgt.getMinY() > cur.getMaxY() ? tgt.getMinY() - cur.getMaxY() : cur.getMinY() - tgt.getMaxY());
        return distance;
    }

    @Override
    public Node select(Node node, Direction dir, TraversalContext context) {
        Node newNode = null;
        List<Node> nodes = context.getAllTargetNodes();
        int target = this.traverse(context.getSceneLayoutBounds(node), dir, nodes, context);
        if (target != -1) {
            newNode = nodes.get(target);
        }
        return newNode;
    }

    @Override
    public Node selectFirst(TraversalContext context) {
        List<Node> nodes = context.getAllTargetNodes();
        Point2D zeroZero = new Point2D(0.0, 0.0);
        if (nodes.size() > 0) {
            Node nearestNode = nodes.get(0);
            double nearestDistance = zeroZero.distance(context.getSceneLayoutBounds(nodes.get(0)).getMinX(), context.getSceneLayoutBounds(nodes.get(0)).getMinY());
            for (int nodeIndex = 1; nodeIndex < nodes.size(); ++nodeIndex) {
                double distance = zeroZero.distance(context.getSceneLayoutBounds(nodes.get(nodeIndex)).getMinX(), context.getSceneLayoutBounds(nodes.get(nodeIndex)).getMinY());
                if (!(nearestDistance > distance)) continue;
                nearestDistance = distance;
                nearestNode = nodes.get(nodeIndex);
            }
            return nearestNode;
        }
        return null;
    }

    @Override
    public Node selectLast(TraversalContext context) {
        return null;
    }

    public int traverse(Bounds origin, Direction dir, List<Node> targets, TraversalContext context) {
        int target = dir == Direction.NEXT || dir == Direction.NEXT_IN_LINE || dir == Direction.PREVIOUS ? this.trav1D(origin, dir, targets, context) : this.trav2D(origin, dir, targets, context);
        return target;
    }

    private int trav2D(Bounds origin, Direction dir, List<Node> targets, TraversalContext context) {
        Bounds bestBounds = null;
        double bestMetric = 0.0;
        int bestIndex = -1;
        for (int i = 0; i < targets.size(); ++i) {
            double metric;
            Bounds targetBounds = context.getSceneLayoutBounds(targets.get(i));
            double outd = this.outDistance(dir, origin, targetBounds);
            if (this.isOnAxis(dir, origin, targetBounds)) {
                metric = outd + this.centerSideDistance(dir, origin, targetBounds) / 100.0;
            } else {
                double cosd = this.cornerSideDistance(dir, origin, targetBounds);
                metric = 100000.0 + outd * outd + 9.0 * cosd * cosd;
            }
            if (outd < 0.0 || bestBounds != null && !(metric < bestMetric)) continue;
            bestBounds = targetBounds;
            bestMetric = metric;
            bestIndex = i;
        }
        return bestIndex;
    }

    private int compare1D(Bounds a, Bounds b) {
        int res = 0;
        double metric1a = (a.getMinY() + a.getMaxY()) / 2.0;
        double metric1b = (b.getMinY() + b.getMaxY()) / 2.0;
        double metric2a = (a.getMinX() + a.getMaxX()) / 2.0;
        double metric2b = (b.getMinX() + b.getMaxX()) / 2.0;
        double metric3a = a.hashCode();
        double metric3b = b.hashCode();
        if (metric1a < metric1b) {
            res = -1;
        } else if (metric1a > metric1b) {
            res = 1;
        } else if (metric2a < metric2b) {
            res = -1;
        } else if (metric2a > metric2b) {
            res = 1;
        } else if (metric3a < metric3b) {
            res = -1;
        } else if (metric3a > metric3b) {
            res = 1;
        }
        return res;
    }

    private int compare1D(Bounds a, Bounds b, Direction dir) {
        return dir != Direction.PREVIOUS ? -this.compare1D(a, b) : this.compare1D(a, b);
    }

    private int trav1D(Bounds origin, Direction dir, List<Node> targets, TraversalContext context) {
        int bestSoFar = -1;
        int leastSoFar = -1;
        for (int i = 0; i < targets.size(); ++i) {
            if (leastSoFar == -1 || this.compare1D(context.getSceneLayoutBounds(targets.get(i)), context.getSceneLayoutBounds(targets.get(leastSoFar)), dir) < 0) {
                leastSoFar = i;
            }
            if (this.compare1D(context.getSceneLayoutBounds(targets.get(i)), origin, dir) < 0 || bestSoFar != -1 && this.compare1D(context.getSceneLayoutBounds(targets.get(i)), context.getSceneLayoutBounds(targets.get(bestSoFar)), dir) >= 0) continue;
            bestSoFar = i;
        }
        return bestSoFar == -1 ? leastSoFar : bestSoFar;
    }
}

