/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.RectBounds;
import java.util.Arrays;

public final class DirtyRegionContainer {
    public static final int DTR_OK = 1;
    public static final int DTR_CONTAINS_CLIP = 0;
    private RectBounds[] dirtyRegions;
    private int emptyIndex;
    private int[][] heap;
    private int heapSize;
    private long invalidMask;

    public DirtyRegionContainer(int count) {
        this.initDirtyRegions(count);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirtyRegionContainer) {
            DirtyRegionContainer drc = (DirtyRegionContainer)obj;
            if (this.size() != drc.size()) {
                return false;
            }
            for (int i = 0; i < this.emptyIndex; ++i) {
                if (this.getDirtyRegion(i).equals(drc.getDirtyRegion(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Arrays.deepHashCode(this.dirtyRegions);
        hash = 97 * hash + this.emptyIndex;
        return hash;
    }

    public DirtyRegionContainer deriveWithNewRegion(RectBounds region) {
        if (region == null) {
            return this;
        }
        this.dirtyRegions[0].deriveWithNewBounds(region);
        this.emptyIndex = 1;
        return this;
    }

    public DirtyRegionContainer deriveWithNewRegions(RectBounds[] regions) {
        if (regions == null || regions.length == 0) {
            return this;
        }
        if (regions.length > this.maxSpace()) {
            this.initDirtyRegions(regions.length);
        }
        this.regioncopy(regions, 0, this.dirtyRegions, 0, regions.length);
        this.emptyIndex = regions.length;
        return this;
    }

    public DirtyRegionContainer deriveWithNewContainer(DirtyRegionContainer other) {
        if (other == null || other.maxSpace() == 0) {
            return this;
        }
        if (other.maxSpace() > this.maxSpace()) {
            this.initDirtyRegions(other.maxSpace());
        }
        this.regioncopy(other.dirtyRegions, 0, this.dirtyRegions, 0, other.emptyIndex);
        this.emptyIndex = other.emptyIndex;
        return this;
    }

    private void initDirtyRegions(int count) {
        this.dirtyRegions = new RectBounds[count];
        for (int i = 0; i < count; ++i) {
            this.dirtyRegions[i] = new RectBounds();
        }
        this.emptyIndex = 0;
    }

    public DirtyRegionContainer copy() {
        DirtyRegionContainer drc = new DirtyRegionContainer(this.maxSpace());
        this.regioncopy(this.dirtyRegions, 0, drc.dirtyRegions, 0, this.emptyIndex);
        drc.emptyIndex = this.emptyIndex;
        return drc;
    }

    public int maxSpace() {
        return this.dirtyRegions.length;
    }

    public RectBounds getDirtyRegion(int index) {
        return this.dirtyRegions[index];
    }

    public void setDirtyRegion(int index, RectBounds region) {
        this.dirtyRegions[index] = region;
    }

    public void addDirtyRegion(RectBounds region) {
        RectBounds dr;
        if (region.isEmpty()) {
            return;
        }
        int tempIndex = 0;
        int regionCount = this.emptyIndex;
        for (int i = 0; i < regionCount; ++i) {
            dr = this.dirtyRegions[tempIndex];
            if (region.intersects(dr)) {
                region.unionWith(dr);
                RectBounds tmp = this.dirtyRegions[tempIndex];
                this.dirtyRegions[tempIndex] = this.dirtyRegions[this.emptyIndex - 1];
                this.dirtyRegions[this.emptyIndex - 1] = tmp;
                --this.emptyIndex;
                continue;
            }
            ++tempIndex;
        }
        if (this.hasSpace()) {
            dr = this.dirtyRegions[this.emptyIndex];
            dr.deriveWithNewBounds(region);
            ++this.emptyIndex;
            return;
        }
        if (this.dirtyRegions.length == 1) {
            this.dirtyRegions[0].deriveWithUnion(region);
        } else {
            this.compress(region);
        }
    }

    public void merge(DirtyRegionContainer other) {
        int otherSize = other.size();
        for (int i = 0; i < otherSize; ++i) {
            this.addDirtyRegion(other.getDirtyRegion(i));
        }
    }

    public int size() {
        return this.emptyIndex;
    }

    public void reset() {
        this.emptyIndex = 0;
    }

    private RectBounds compress(RectBounds region) {
        this.compress_heap();
        this.addDirtyRegion(region);
        return region;
    }

    private boolean hasSpace() {
        return this.emptyIndex < this.dirtyRegions.length;
    }

    private void regioncopy(RectBounds[] src, int from, RectBounds[] dest, int to, int length) {
        for (int i = 0; i < length; ++i) {
            RectBounds rb;
            if ((rb = src[from++]) == null) {
                dest[to++].makeEmpty();
                continue;
            }
            dest[to++].deriveWithNewBounds(rb);
        }
    }

    public boolean checkAndClearRegion(int index) {
        boolean removed = false;
        if (this.dirtyRegions[index].isEmpty()) {
            System.arraycopy(this.dirtyRegions, index + 1, this.dirtyRegions, index, this.emptyIndex - index - 1);
            --this.emptyIndex;
            removed = true;
        }
        return removed;
    }

    public void grow(int horizontal, int vertical) {
        if (horizontal != 0 || vertical != 0) {
            for (int i = 0; i < this.emptyIndex; ++i) {
                this.getDirtyRegion(i).grow(horizontal, vertical);
            }
        }
    }

    public void roundOut() {
        for (int i = 0; i < this.emptyIndex; ++i) {
            this.dirtyRegions[i].roundOut();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.emptyIndex; ++i) {
            sb.append(this.dirtyRegions[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    private void heapCompress() {
        this.invalidMask = 0L;
        int[] map = new int[this.dirtyRegions.length];
        for (int i = 0; i < map.length; ++i) {
            map[i] = i;
        }
        for (int i = 0; i < this.dirtyRegions.length / 2; ++i) {
            int idx1;
            int[] min = this.takeMinWithMap(map);
            int idx0 = this.resolveMap(map, min[1]);
            if (idx0 == (idx1 = this.resolveMap(map, min[2]))) continue;
            this.dirtyRegions[idx0].deriveWithUnion(this.dirtyRegions[idx1]);
            map[idx1] = idx0;
            this.invalidMask |= (long)(1 << idx0);
            this.invalidMask |= (long)(1 << idx1);
        }
        for (int i = 0; i < this.emptyIndex; ++i) {
            if (map[i] == i) continue;
            while (map[this.emptyIndex - 1] != this.emptyIndex - 1) {
                --this.emptyIndex;
            }
            if (i >= this.emptyIndex - 1) continue;
            RectBounds tmp = this.dirtyRegions[this.emptyIndex - 1];
            this.dirtyRegions[this.emptyIndex - 1] = this.dirtyRegions[i];
            this.dirtyRegions[i] = tmp;
            map[i] = i;
            --this.emptyIndex;
        }
    }

    private void heapify() {
        for (int i = this.heapSize / 2; i >= 0; --i) {
            this.siftDown(i);
        }
    }

    private void siftDown(int i) {
        int end = this.heapSize >> 1;
        while (i < end) {
            int child = (i << 1) + 1;
            int[] left = this.heap[child];
            if (child + 1 < this.heapSize && this.heap[child + 1][0] < left[0]) {
                ++child;
            }
            if (this.heap[child][0] >= this.heap[i][0]) break;
            int[] temp = this.heap[child];
            this.heap[child] = this.heap[i];
            this.heap[i] = temp;
            i = child;
        }
    }

    private int[] takeMinWithMap(int[] map) {
        int[] temp = this.heap[0];
        while (((long)(1 << temp[1] | 1 << temp[2]) & this.invalidMask) > 0L) {
            temp[0] = this.unifiedRegionArea(this.resolveMap(map, temp[1]), this.resolveMap(map, temp[2]));
            this.siftDown(0);
            if (this.heap[0] == temp) break;
            temp = this.heap[0];
        }
        this.heap[this.heapSize - 1] = temp;
        this.siftDown(0);
        --this.heapSize;
        return temp;
    }

    private int[] takeMin() {
        int[] temp = this.heap[0];
        this.heap[0] = this.heap[this.heapSize - 1];
        this.heap[this.heapSize - 1] = temp;
        this.siftDown(0);
        --this.heapSize;
        return temp;
    }

    private int resolveMap(int[] map, int idx) {
        while (map[idx] != idx) {
            idx = map[idx];
        }
        return idx;
    }

    private int unifiedRegionArea(int i0, int i1) {
        RectBounds r0 = this.dirtyRegions[i0];
        RectBounds r1 = this.dirtyRegions[i1];
        float minX = r0.getMinX() < r1.getMinX() ? r0.getMinX() : r1.getMinX();
        float minY = r0.getMinY() < r1.getMinY() ? r0.getMinY() : r1.getMinY();
        float maxX = r0.getMaxX() > r1.getMaxX() ? r0.getMaxX() : r1.getMaxX();
        float maxY = r0.getMaxY() > r1.getMaxY() ? r0.getMaxY() : r1.getMaxY();
        return (int)((maxX - minX) * (maxY - minY));
    }

    private void compress_heap() {
        assert (this.dirtyRegions.length == this.emptyIndex);
        if (this.heap == null) {
            int n = this.dirtyRegions.length;
            this.heap = new int[n * (n - 1) / 2][3];
        }
        this.heapSize = this.heap.length;
        int k = 0;
        for (int i = 0; i < this.dirtyRegions.length - 1; ++i) {
            int j = i + 1;
            while (j < this.dirtyRegions.length) {
                this.heap[k][0] = this.unifiedRegionArea(i, j);
                this.heap[k][1] = i;
                this.heap[k++][2] = j++;
            }
        }
        this.heapify();
        this.heapCompress();
    }
}

