/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;

public class CascadingStyle
implements Comparable<CascadingStyle> {
    private final Style style;
    private final Set<PseudoClass> pseudoClasses;
    private final int specificity;
    private final int ordinal;
    private final boolean skinProp;

    public Style getStyle() {
        return this.style;
    }

    public CascadingStyle(Style style, Set<PseudoClass> pseudoClasses, int specificity, int ordinal) {
        this.style = style;
        this.pseudoClasses = pseudoClasses;
        this.specificity = specificity;
        this.ordinal = ordinal;
        this.skinProp = "-fx-skin".equals(style.getDeclaration().getProperty());
    }

    public String getProperty() {
        return this.style.getDeclaration().getProperty();
    }

    public Selector getSelector() {
        return this.style.getSelector();
    }

    public Rule getRule() {
        return this.style.getDeclaration().getRule();
    }

    public StyleOrigin getOrigin() {
        return this.getRule().getOrigin();
    }

    public ParsedValueImpl getParsedValueImpl() {
        return this.style.getDeclaration().getParsedValueImpl();
    }

    public String toString() {
        return this.getProperty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CascadingStyle other = (CascadingStyle)obj;
        String property = this.getProperty();
        String otherProperty = other.getProperty();
        if (property == null ? otherProperty != null : !property.equals(otherProperty)) {
            return false;
        }
        return !(this.pseudoClasses == null ? other.pseudoClasses != null : !this.pseudoClasses.containsAll(other.pseudoClasses));
    }

    public int hashCode() {
        int hash = 7;
        String property = this.getProperty();
        hash = 47 * hash + (property != null ? property.hashCode() : 0);
        hash = 47 * hash + (this.pseudoClasses != null ? this.pseudoClasses.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(CascadingStyle other) {
        Declaration decl = this.style.getDeclaration();
        boolean important = decl != null ? decl.isImportant() : false;
        Rule rule = decl != null ? decl.getRule() : null;
        StyleOrigin source = rule != null ? rule.getOrigin() : null;
        Declaration otherDecl = other.style.getDeclaration();
        boolean otherImportant = otherDecl != null ? otherDecl.isImportant() : false;
        Rule otherRule = otherDecl != null ? otherDecl.getRule() : null;
        StyleOrigin otherSource = otherRule != null ? otherRule.getOrigin() : null;
        int c = 0;
        c = this.skinProp && !other.skinProp ? 1 : (important != otherImportant ? (important ? -1 : 1) : (source != otherSource ? (source == null ? -1 : (otherSource == null ? 1 : otherSource.compareTo(source))) : other.specificity - this.specificity));
        if (c == 0) {
            c = other.ordinal - this.ordinal;
        }
        return c;
    }
}

