/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.Cvs2Configurable;
import com.intellij.cvsSupport2.CvsDiffProvider;
import com.intellij.cvsSupport2.CvsRevisionSelector;
import com.intellij.cvsSupport2.CvsStandardOperationsProvider;
import com.intellij.cvsSupport2.CvsStatusEnvironment;
import com.intellij.cvsSupport2.CvsUpdateEnvironment;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsMergeProvider;
import com.intellij.cvsSupport2.annotate.CvsAnnotationProvider;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.changeBrowser.CvsChangeList;
import com.intellij.cvsSupport2.changeBrowser.CvsCommittedChangesProvider;
import com.intellij.cvsSupport2.checkinProject.CvsCheckinEnvironment;
import com.intellij.cvsSupport2.checkinProject.CvsRollbackEnvironment;
import com.intellij.cvsSupport2.checkout.CvsCheckoutProvider;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.FindAllRootsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditOptionsDialog;
import com.intellij.cvsSupport2.cvsstatuses.CvsChangeProvider;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.history.CvsHistoryProvider;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsVcs2
extends AbstractVcs<CvsChangeList>
implements TransactionProvider,
EditFileProvider {
    private static final String NAME = "CVS";
    private static final VcsKey ourKey = CvsVcs2.createKey((String)"CVS");
    private final Cvs2Configurable myConfigurable;
    private CvsStorageComponent myStorageComponent;
    private final CvsHistoryProvider myCvsHistoryProvider;
    private final CvsCheckinEnvironment myCvsCheckinEnvironment;
    private final CvsCheckoutProvider myCvsCheckoutProvider;
    private RollbackEnvironment myCvsRollbackEnvironment;
    private final CvsStandardOperationsProvider myCvsStandardOperationsProvider;
    private final CvsUpdateEnvironment myCvsUpdateEnvironment;
    private final CvsStatusEnvironment myCvsStatusEnvironment;
    private final CvsAnnotationProvider myCvsAnnotationProvider;
    private final CvsDiffProvider myDiffProvider;
    private final CvsCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myAddOptions;
    private final VcsShowSettingOption myRemoveOptions;
    private final VcsShowSettingOption myCheckoutOptions;
    private final VcsShowSettingOption myEditOption;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myRemoveConfirmation;
    private final CvsEntriesListener myCvsEntriesListener;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;

    public CvsVcs2(@NotNull Project project, CvsStorageComponent cvsStorageComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cvsSupport2/CvsVcs2", "<init>"));
        }
        super(project, NAME);
        this.myStorageComponent = CvsStorageComponent.ABSENT_STORAGE;
        this.myCvsHistoryProvider = new CvsHistoryProvider(project);
        this.myCvsCheckinEnvironment = new CvsCheckinEnvironment(this.getProject());
        this.myCvsCheckoutProvider = new CvsCheckoutProvider();
        this.myCvsStandardOperationsProvider = new CvsStandardOperationsProvider(project);
        this.myCvsUpdateEnvironment = new CvsUpdateEnvironment(project);
        this.myCvsStatusEnvironment = new CvsStatusEnvironment(this.myProject);
        this.myConfigurable = new Cvs2Configurable(this.getProject());
        this.myStorageComponent = cvsStorageComponent;
        this.myCvsAnnotationProvider = new CvsAnnotationProvider(this.myProject, this.myCvsHistoryProvider);
        this.myDiffProvider = new CvsDiffProvider(this.myProject);
        this.myCommittedChangesProvider = new CvsCommittedChangesProvider(this.myProject);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myRemoveOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.ADD, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        this.myEditOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.EDIT, (AbstractVcs)this);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myRemoveConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCvsEntriesListener = new CvsEntriesListener(){

            @Override
            public void entriesChanged(VirtualFile parent) {
                VirtualFile[] children = parent.getChildren();
                if (children == null) {
                    return;
                }
                for (VirtualFile child : children) {
                    CvsVcs2.this.fireFileStatusChanged(child);
                }
                VcsDirtyScopeManager.getInstance((Project)CvsVcs2.this.getProject()).fileDirty(parent);
            }

            @Override
            public void entryChanged(VirtualFile file) {
                if (CvsVcs2.this.myProject.isDisposed()) {
                    return;
                }
                CvsVcs2.this.fireFileStatusChanged(file);
                VcsDirtyScopeManager.getInstance((Project)CvsVcs2.this.getProject()).fileDirty(file);
            }
        };
    }

    public String getDisplayName() {
        return CvsBundle.getCvsDisplayName();
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public TransactionProvider getTransactionProvider() {
        return this;
    }

    public void startTransaction(Object parameters) throws VcsException {
        this.myCvsStandardOperationsProvider.createTransaction();
    }

    public void commitTransaction(Object parameters) throws VcsException {
        this.myCvsStandardOperationsProvider.commit(parameters);
    }

    public void rollbackTransaction(Object parameters) {
        this.myCvsStandardOperationsProvider.rollback();
    }

    public CvsStandardOperationsProvider getStandardOperationsProvider() {
        return this.myCvsStandardOperationsProvider;
    }

    public static CvsVcs2 getInstance(Project project) {
        return (CvsVcs2)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    public int getFilesToProcessCount() {
        return this.myCvsStandardOperationsProvider.getFilesToProcessCount();
    }

    public static void executeOperation(String title, CvsOperation operation, Project project) throws VcsException {
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        CvsResult result = executor.getResult();
        if (result.hasErrors()) {
            throw result.composeError();
        }
    }

    public static CvsOperationExecutor executeQuietOperation(String title, CvsOperation operation, Project project) {
        CvsOperationExecutor executor = new CvsOperationExecutor(false, project, ModalityState.defaultModalityState());
        executor.setIsQuietOperation(true);
        executor.performActionSync(new CommandCvsHandler(title, operation), CvsOperationExecutorCallback.EMPTY);
        return executor;
    }

    public VcsShowSettingOption getAddOptions() {
        return this.myAddOptions;
    }

    public VcsShowSettingOption getRemoveOptions() {
        return this.myRemoveOptions;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        return this;
    }

    public void editFiles(VirtualFile[] files) {
        EditOptionsDialog editOptionsDialog;
        if (this.getEditOptions().getValue() && !(editOptionsDialog = new EditOptionsDialog(this.myProject)).showAndGet()) {
            return;
        }
        CvsHandler editHandler = CommandCvsHandler.createEditHandler(files, CvsConfiguration.getInstance((Project)this.myProject).RESERVED_EDIT);
        new CvsOperationExecutor(true, this.myProject, ModalityState.current()).performActionSync(editHandler, CvsOperationExecutorCallback.EMPTY);
    }

    public String getRequestText() {
        return CvsBundle.message((String)"message.text.edit.file.request", (Object[])new Object[0]);
    }

    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new CvsChangeProvider(this, CvsEntriesManager.getInstance());
        }
        return this.myChangeProvider;
    }

    protected void activate() {
        this.myStorageComponent.init(this.getProject(), false);
        CvsEntriesManager.getInstance().addCvsEntriesListener(this.myCvsEntriesListener);
    }

    protected void deactivate() {
        this.myStorageComponent.dispose();
        CvsEntriesManager.getInstance().removeCvsEntriesListener(this.myCvsEntriesListener);
    }

    private void fireFileStatusChanged(VirtualFile file) {
        FileStatusManager.getInstance((Project)this.getProject()).fileStatusChanged(file);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        CvsCheckinEnvironment cvsCheckinEnvironment = this.myCvsCheckinEnvironment;
        if (cvsCheckinEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsVcs2", "createCheckinEnvironment"));
        }
        return cvsCheckinEnvironment;
    }

    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myCvsRollbackEnvironment == null) {
            this.myCvsRollbackEnvironment = new CvsRollbackEnvironment(this.myProject);
        }
        return this.myCvsRollbackEnvironment;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.myCvsHistoryProvider;
    }

    @NotNull
    public VcsHistoryProvider getVcsHistoryProvider() {
        CvsHistoryProvider cvsHistoryProvider = this.myCvsHistoryProvider;
        if (cvsHistoryProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsVcs2", "getVcsHistoryProvider"));
        }
        return cvsHistoryProvider;
    }

    public String getMenuItemText() {
        return CvsBundle.message((String)"menu.text.cvsGroup", (Object[])new Object[0]);
    }

    public UpdateEnvironment createUpdateEnvironment() {
        return this.myCvsUpdateEnvironment;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return CvsUtil.fileIsUnderCvs(filePath.getIOFile());
    }

    public boolean fileExistsInVcs(FilePath path) {
        return CvsUtil.fileExistsInCvs(path);
    }

    public UpdateEnvironment getStatusEnvironment() {
        return this.myCvsStatusEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.myCvsAnnotationProvider;
    }

    public FileAnnotation createAnnotation(VirtualFile cvsVirtualFile, String revision, CvsEnvironment environment) throws VcsException {
        return this.myCvsAnnotationProvider.annotate(cvsVirtualFile, revision, environment);
    }

    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    public VcsShowSettingOption getEditOptions() {
        return this.myEditOption;
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getRemoveConfirmation() {
        return this.myRemoveConfirmation;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return new CvsRevisionSelector(this.myProject);
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return new CvsRevisionNumber(revisionNumberString);
    }

    public String getRevisionPattern() {
        return "\\d+(\\.\\d+)*";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        VirtualFile child = dir.findChild(NAME);
        return child != null && child.isDirectory();
    }

    public CvsCheckoutProvider getCheckoutProvider() {
        return this.myCvsCheckoutProvider;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return new AbstractVcs.RootsConvertor(){

            @NotNull
            public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/cvsSupport2/CvsVcs2$2", "convertRoots"));
                }
                List<VirtualFile> list = FindAllRootsHelper.findVersionedUnder(result);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsVcs2$2", "convertRoots"));
                }
                return list;
            }
        };
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider != null) {
            this.myMergeProvider = new CvsMergeProvider();
        }
        return this.myMergeProvider;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        return in;
    }
}

