/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.GaiException;
import android.system.StructAddrinfo;
import android.system.StructFlock;
import android.system.StructGroupReq;
import android.system.StructGroupSourceReq;
import android.system.StructLinger;
import android.system.StructPasswd;
import android.system.StructPollfd;
import android.system.StructStat;
import android.system.StructStatVfs;
import android.system.StructTimeval;
import android.system.StructUcred;
import android.system.StructUtsname;
import android.util.MutableInt;
import android.util.MutableLong;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import libcore.io.Os;

public class Posix
implements Os {
    Posix() {
    }

    @Override
    public FileDescriptor accept(FileDescriptor fileDescriptor, SocketAddress socketAddress) throws ErrnoException, SocketException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#accept(Ljava/io/FileDescriptor;Ljava/net/SocketAddress;)Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public boolean access(String string2, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#access(Ljava/lang/String;I)Z", true, this) != 0;
    }

    @Override
    public InetAddress[] android_getaddrinfo(String string2, StructAddrinfo structAddrinfo, int n) throws GaiException {
        return (InetAddress[])OverrideMethod.invokeA("libcore.io.Posix#android_getaddrinfo(Ljava/lang/String;Landroid/system/StructAddrinfo;I)[Ljava/net/InetAddress;", true, this);
    }

    @Override
    public void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#bind(Ljava/io/FileDescriptor;Ljava/net/InetAddress;I)V", true, this);
    }

    @Override
    public void bind(FileDescriptor fileDescriptor, SocketAddress socketAddress) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#bind(Ljava/io/FileDescriptor;Ljava/net/SocketAddress;)V", true, this);
    }

    @Override
    public void chmod(String string2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#chmod(Ljava/lang/String;I)V", true, this);
    }

    @Override
    public void chown(String string2, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#chown(Ljava/lang/String;II)V", true, this);
    }

    @Override
    public void close(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#close(Ljava/io/FileDescriptor;)V", true, this);
    }

    @Override
    public void connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#connect(Ljava/io/FileDescriptor;Ljava/net/InetAddress;I)V", true, this);
    }

    @Override
    public void connect(FileDescriptor fileDescriptor, SocketAddress socketAddress) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#connect(Ljava/io/FileDescriptor;Ljava/net/SocketAddress;)V", true, this);
    }

    @Override
    public FileDescriptor dup(FileDescriptor fileDescriptor) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#dup(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public FileDescriptor dup2(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#dup2(Ljava/io/FileDescriptor;I)Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public String[] environ() {
        return (String[])OverrideMethod.invokeA("libcore.io.Posix#environ()[Ljava/lang/String;", true, this);
    }

    @Override
    public void execv(String string2, String[] stringArray) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#execv(Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    @Override
    public void execve(String string2, String[] stringArray, String[] stringArray2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#execve(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    @Override
    public void fchmod(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fchmod(Ljava/io/FileDescriptor;I)V", true, this);
    }

    @Override
    public void fchown(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fchown(Ljava/io/FileDescriptor;II)V", true, this);
    }

    @Override
    public int fcntlFlock(FileDescriptor fileDescriptor, int n, StructFlock structFlock) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlFlock(Ljava/io/FileDescriptor;ILandroid/system/StructFlock;)I", true, this);
    }

    @Override
    public int fcntlInt(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlInt(Ljava/io/FileDescriptor;II)I", true, this);
    }

    @Override
    public int fcntlVoid(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlVoid(Ljava/io/FileDescriptor;I)I", true, this);
    }

    @Override
    public void fdatasync(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fdatasync(Ljava/io/FileDescriptor;)V", true, this);
    }

    @Override
    public StructStat fstat(FileDescriptor fileDescriptor) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#fstat(Ljava/io/FileDescriptor;)Landroid/system/StructStat;", true, this);
    }

    @Override
    public StructStatVfs fstatvfs(FileDescriptor fileDescriptor) throws ErrnoException {
        return (StructStatVfs)OverrideMethod.invokeA("libcore.io.Posix#fstatvfs(Ljava/io/FileDescriptor;)Landroid/system/StructStatVfs;", true, this);
    }

    @Override
    public void fsync(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fsync(Ljava/io/FileDescriptor;)V", true, this);
    }

    @Override
    public void ftruncate(FileDescriptor fileDescriptor, long l) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#ftruncate(Ljava/io/FileDescriptor;J)V", true, this);
    }

    @Override
    public String gai_strerror(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#gai_strerror(I)Ljava/lang/String;", true, this);
    }

    @Override
    public int getegid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getegid()I", true, this);
    }

    @Override
    public int geteuid() {
        return OverrideMethod.invokeI("libcore.io.Posix#geteuid()I", true, this);
    }

    @Override
    public int getgid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getgid()I", true, this);
    }

    @Override
    public String getenv(String string2) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#getenv(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    @Override
    public String getnameinfo(InetAddress inetAddress, int n) throws GaiException {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#getnameinfo(Ljava/net/InetAddress;I)Ljava/lang/String;", true, this);
    }

    @Override
    public SocketAddress getpeername(FileDescriptor fileDescriptor) throws ErrnoException {
        return (SocketAddress)OverrideMethod.invokeA("libcore.io.Posix#getpeername(Ljava/io/FileDescriptor;)Ljava/net/SocketAddress;", true, this);
    }

    @Override
    public int getpgid(int n) {
        return OverrideMethod.invokeI("libcore.io.Posix#getpgid(I)I", true, this);
    }

    @Override
    public int getpid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getpid()I", true, this);
    }

    @Override
    public int getppid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getppid()I", true, this);
    }

    @Override
    public StructPasswd getpwnam(String string2) throws ErrnoException {
        return (StructPasswd)OverrideMethod.invokeA("libcore.io.Posix#getpwnam(Ljava/lang/String;)Landroid/system/StructPasswd;", true, this);
    }

    @Override
    public StructPasswd getpwuid(int n) throws ErrnoException {
        return (StructPasswd)OverrideMethod.invokeA("libcore.io.Posix#getpwuid(I)Landroid/system/StructPasswd;", true, this);
    }

    @Override
    public SocketAddress getsockname(FileDescriptor fileDescriptor) throws ErrnoException {
        return (SocketAddress)OverrideMethod.invokeA("libcore.io.Posix#getsockname(Ljava/io/FileDescriptor;)Ljava/net/SocketAddress;", true, this);
    }

    @Override
    public int getsockoptByte(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#getsockoptByte(Ljava/io/FileDescriptor;II)I", true, this);
    }

    @Override
    public InetAddress getsockoptInAddr(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#getsockoptInAddr(Ljava/io/FileDescriptor;II)Ljava/net/InetAddress;", true, this);
    }

    @Override
    public int getsockoptInt(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#getsockoptInt(Ljava/io/FileDescriptor;II)I", true, this);
    }

    @Override
    public StructLinger getsockoptLinger(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructLinger)OverrideMethod.invokeA("libcore.io.Posix#getsockoptLinger(Ljava/io/FileDescriptor;II)Landroid/system/StructLinger;", true, this);
    }

    @Override
    public StructTimeval getsockoptTimeval(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructTimeval)OverrideMethod.invokeA("libcore.io.Posix#getsockoptTimeval(Ljava/io/FileDescriptor;II)Landroid/system/StructTimeval;", true, this);
    }

    @Override
    public StructUcred getsockoptUcred(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructUcred)OverrideMethod.invokeA("libcore.io.Posix#getsockoptUcred(Ljava/io/FileDescriptor;II)Landroid/system/StructUcred;", true, this);
    }

    @Override
    public int gettid() {
        return OverrideMethod.invokeI("libcore.io.Posix#gettid()I", true, this);
    }

    @Override
    public int getuid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getuid()I", true, this);
    }

    @Override
    public int getxattr(String string2, String string3, byte[] byArray) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#getxattr(Ljava/lang/String;Ljava/lang/String;[B)I", true, this);
    }

    @Override
    public String if_indextoname(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#if_indextoname(I)Ljava/lang/String;", true, this);
    }

    @Override
    public InetAddress inet_pton(int n, String string2) {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#inet_pton(ILjava/lang/String;)Ljava/net/InetAddress;", true, this);
    }

    @Override
    public InetAddress ioctlInetAddress(FileDescriptor fileDescriptor, int n, String string2) throws ErrnoException {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#ioctlInetAddress(Ljava/io/FileDescriptor;ILjava/lang/String;)Ljava/net/InetAddress;", true, this);
    }

    @Override
    public int ioctlInt(FileDescriptor fileDescriptor, int n, MutableInt mutableInt) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#ioctlInt(Ljava/io/FileDescriptor;ILandroid/util/MutableInt;)I", true, this);
    }

    @Override
    public boolean isatty(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("libcore.io.Posix#isatty(Ljava/io/FileDescriptor;)Z", true, this) != 0;
    }

    @Override
    public void kill(int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#kill(II)V", true, this);
    }

    @Override
    public void lchown(String string2, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#lchown(Ljava/lang/String;II)V", true, this);
    }

    @Override
    public void link(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#link(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    @Override
    public void listen(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#listen(Ljava/io/FileDescriptor;I)V", true, this);
    }

    @Override
    public long lseek(FileDescriptor fileDescriptor, long l, int n) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#lseek(Ljava/io/FileDescriptor;JI)J", true, this);
    }

    @Override
    public StructStat lstat(String string2) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#lstat(Ljava/lang/String;)Landroid/system/StructStat;", true, this);
    }

    @Override
    public void mincore(long l, long l2, byte[] byArray) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mincore(JJ[B)V", true, this);
    }

    @Override
    public void mkdir(String string2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mkdir(Ljava/lang/String;I)V", true, this);
    }

    @Override
    public void mkfifo(String string2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mkfifo(Ljava/lang/String;I)V", true, this);
    }

    @Override
    public void mlock(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mlock(JJ)V", true, this);
    }

    @Override
    public long mmap(long l, long l2, int n, int n2, FileDescriptor fileDescriptor, long l3) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#mmap(JJIILjava/io/FileDescriptor;J)J", true, this);
    }

    @Override
    public void msync(long l, long l2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#msync(JJI)V", true, this);
    }

    @Override
    public void munlock(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#munlock(JJ)V", true, this);
    }

    @Override
    public void munmap(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#munmap(JJ)V", true, this);
    }

    @Override
    public FileDescriptor open(String string2, int n, int n2) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#open(Ljava/lang/String;II)Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public FileDescriptor[] pipe2(int n) throws ErrnoException {
        return (FileDescriptor[])OverrideMethod.invokeA("libcore.io.Posix#pipe2(I)[Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public int poll(StructPollfd[] structPollfdArray, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#poll([Landroid/system/StructPollfd;I)I", true, this);
    }

    @Override
    public void posix_fallocate(FileDescriptor fileDescriptor, long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#posix_fallocate(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    @Override
    public int prctl(int n, long l, long l2, long l3, long l4) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#prctl(IJJJJ)I", true, this);
    }

    @Override
    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesRead = buffer.isDirect() ? this.preadBytes(fd, buffer, position, buffer.remaining(), offset) : this.preadBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining(), offset);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesRead);
        return bytesRead;
    }

    @Override
    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        return this.preadBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private int preadBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, long l) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#preadBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIJ)I", true, this);
    }

    @Override
    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesWritten = buffer.isDirect() ? this.pwriteBytes(fd, buffer, position, buffer.remaining(), offset) : this.pwriteBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining(), offset);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesWritten);
        return bytesWritten;
    }

    @Override
    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException, InterruptedIOException {
        return this.pwriteBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private int pwriteBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, long l) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#pwriteBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIJ)I", true, this);
    }

    @Override
    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesRead = buffer.isDirect() ? this.readBytes(fd, buffer, position, buffer.remaining()) : this.readBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining());
        Posix.maybeUpdateBufferPosition(buffer, position, bytesRead);
        return bytesRead;
    }

    @Override
    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        return this.readBytes(fd, bytes, byteOffset, byteCount);
    }

    private int readBytes(FileDescriptor fileDescriptor, Object object, int n, int n2) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#readBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;II)I", true, this);
    }

    @Override
    public String readlink(String string2) throws ErrnoException {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#readlink(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    @Override
    public String realpath(String string2) throws ErrnoException {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#realpath(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    @Override
    public int readv(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#readv(Ljava/io/FileDescriptor;[Ljava/lang/Object;[I[I)I", true, this);
    }

    @Override
    public int recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        int position = buffer.position();
        int bytesReceived = buffer.isDirect() ? this.recvfromBytes(fd, buffer, position, buffer.remaining(), flags, srcAddress) : this.recvfromBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining(), flags, srcAddress);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesReceived);
        return bytesReceived;
    }

    @Override
    public int recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.recvfromBytes(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    private int recvfromBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, int n3, InetSocketAddress inetSocketAddress) throws ErrnoException, SocketException {
        return OverrideMethod.invokeI("libcore.io.Posix#recvfromBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIILjava/net/InetSocketAddress;)I", true, this);
    }

    @Override
    public void remove(String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#remove(Ljava/lang/String;)V", true, this);
    }

    @Override
    public void removexattr(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#removexattr(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    @Override
    public void rename(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#rename(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    @Override
    public long sendfile(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, MutableLong mutableLong, long l) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#sendfile(Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;Landroid/util/MutableLong;J)J", true, this);
    }

    @Override
    public int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        int position = buffer.position();
        int bytesSent = buffer.isDirect() ? this.sendtoBytes(fd, buffer, position, buffer.remaining(), flags, inetAddress, port) : this.sendtoBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining(), flags, inetAddress, port);
        Posix.maybeUpdateBufferPosition(buffer, position, bytesSent);
        return bytesSent;
    }

    @Override
    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    @Override
    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, SocketAddress address) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, address);
    }

    private int sendtoBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, int n3, InetAddress inetAddress, int n4) throws ErrnoException, SocketException {
        return OverrideMethod.invokeI("libcore.io.Posix#sendtoBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIILjava/net/InetAddress;I)I", true, this);
    }

    private int sendtoBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, int n3, SocketAddress socketAddress) throws ErrnoException, SocketException {
        return OverrideMethod.invokeI("libcore.io.Posix#sendtoBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIILjava/net/SocketAddress;)I", true, this);
    }

    @Override
    public void setegid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setegid(I)V", true, this);
    }

    @Override
    public void setenv(String string2, String string3, boolean bl) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setenv(Ljava/lang/String;Ljava/lang/String;Z)V", true, this);
    }

    @Override
    public void seteuid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#seteuid(I)V", true, this);
    }

    @Override
    public void setgid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setgid(I)V", true, this);
    }

    @Override
    public void setpgid(int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setpgid(II)V", true, this);
    }

    @Override
    public void setregid(int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setregid(II)V", true, this);
    }

    @Override
    public void setreuid(int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setreuid(II)V", true, this);
    }

    @Override
    public int setsid() throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#setsid()I", true, this);
    }

    @Override
    public void setsockoptByte(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptByte(Ljava/io/FileDescriptor;III)V", true, this);
    }

    @Override
    public void setsockoptIfreq(FileDescriptor fileDescriptor, int n, int n2, String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptIfreq(Ljava/io/FileDescriptor;IILjava/lang/String;)V", true, this);
    }

    @Override
    public void setsockoptInt(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptInt(Ljava/io/FileDescriptor;III)V", true, this);
    }

    @Override
    public void setsockoptIpMreqn(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptIpMreqn(Ljava/io/FileDescriptor;III)V", true, this);
    }

    @Override
    public void setsockoptGroupReq(FileDescriptor fileDescriptor, int n, int n2, StructGroupReq structGroupReq) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptGroupReq(Ljava/io/FileDescriptor;IILandroid/system/StructGroupReq;)V", true, this);
    }

    @Override
    public void setsockoptGroupSourceReq(FileDescriptor fileDescriptor, int n, int n2, StructGroupSourceReq structGroupSourceReq) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptGroupSourceReq(Ljava/io/FileDescriptor;IILandroid/system/StructGroupSourceReq;)V", true, this);
    }

    @Override
    public void setsockoptLinger(FileDescriptor fileDescriptor, int n, int n2, StructLinger structLinger) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptLinger(Ljava/io/FileDescriptor;IILandroid/system/StructLinger;)V", true, this);
    }

    @Override
    public void setsockoptTimeval(FileDescriptor fileDescriptor, int n, int n2, StructTimeval structTimeval) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptTimeval(Ljava/io/FileDescriptor;IILandroid/system/StructTimeval;)V", true, this);
    }

    @Override
    public void setuid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setuid(I)V", true, this);
    }

    @Override
    public void setxattr(String string2, String string3, byte[] byArray, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setxattr(Ljava/lang/String;Ljava/lang/String;[BI)V", true, this);
    }

    @Override
    public void shutdown(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#shutdown(Ljava/io/FileDescriptor;I)V", true, this);
    }

    @Override
    public FileDescriptor socket(int n, int n2, int n3) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#socket(III)Ljava/io/FileDescriptor;", true, this);
    }

    @Override
    public void socketpair(int n, int n2, int n3, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#socketpair(IIILjava/io/FileDescriptor;Ljava/io/FileDescriptor;)V", true, this);
    }

    @Override
    public StructStat stat(String string2) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#stat(Ljava/lang/String;)Landroid/system/StructStat;", true, this);
    }

    @Override
    public StructStatVfs statvfs(String string2) throws ErrnoException {
        return (StructStatVfs)OverrideMethod.invokeA("libcore.io.Posix#statvfs(Ljava/lang/String;)Landroid/system/StructStatVfs;", true, this);
    }

    @Override
    public String strerror(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#strerror(I)Ljava/lang/String;", true, this);
    }

    @Override
    public String strsignal(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#strsignal(I)Ljava/lang/String;", true, this);
    }

    @Override
    public void symlink(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#symlink(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    @Override
    public long sysconf(int n) {
        return OverrideMethod.invokeL("libcore.io.Posix#sysconf(I)J", true, this);
    }

    @Override
    public void tcdrain(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#tcdrain(Ljava/io/FileDescriptor;)V", true, this);
    }

    @Override
    public void tcsendbreak(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#tcsendbreak(Ljava/io/FileDescriptor;I)V", true, this);
    }

    @Override
    public int umask(int mask) {
        if ((mask & 0x1FF) != mask) {
            throw new IllegalArgumentException("Invalid umask: " + mask);
        }
        return this.umaskImpl(mask);
    }

    private int umaskImpl(int n) {
        return OverrideMethod.invokeI("libcore.io.Posix#umaskImpl(I)I", true, this);
    }

    @Override
    public StructUtsname uname() {
        return (StructUtsname)OverrideMethod.invokeA("libcore.io.Posix#uname()Landroid/system/StructUtsname;", true, this);
    }

    @Override
    public void unlink(String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#unlink(Ljava/lang/String;)V", true, this);
    }

    @Override
    public void unsetenv(String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#unsetenv(Ljava/lang/String;)V", true, this);
    }

    @Override
    public int waitpid(int n, MutableInt mutableInt, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#waitpid(ILandroid/util/MutableInt;I)I", true, this);
    }

    @Override
    public int write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException, InterruptedIOException {
        int position = buffer.position();
        int bytesWritten = buffer.isDirect() ? this.writeBytes(fd, buffer, position, buffer.remaining()) : this.writeBytes(fd, NioUtils.unsafeArray((ByteBuffer)buffer), NioUtils.unsafeArrayOffset((ByteBuffer)buffer) + position, buffer.remaining());
        Posix.maybeUpdateBufferPosition(buffer, position, bytesWritten);
        return bytesWritten;
    }

    @Override
    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException, InterruptedIOException {
        return this.writeBytes(fd, bytes, byteOffset, byteCount);
    }

    private int writeBytes(FileDescriptor fileDescriptor, Object object, int n, int n2) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#writeBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;II)I", true, this);
    }

    @Override
    public int writev(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException, InterruptedIOException {
        return OverrideMethod.invokeI("libcore.io.Posix#writev(Ljava/io/FileDescriptor;[Ljava/lang/Object;[I[I)I", true, this);
    }

    private static void maybeUpdateBufferPosition(ByteBuffer buffer, int originalPosition, int bytesReadOrWritten) {
        if (bytesReadOrWritten > 0) {
            buffer.position(bytesReadOrWritten + originalPosition);
        }
    }
}

