/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.view.View;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.util.ReflectionUtils;

public class DrawerLayoutUtil {
    public static final String CN_DRAWER_LAYOUT = "android.support.v4.widget.DrawerLayout";

    public static void openDrawer(View drawerLayout, String drawerGravity) {
        int gravity = -1;
        if ("left".equals(drawerGravity)) {
            gravity = 3;
        } else if ("right".equals(drawerGravity)) {
            gravity = 5;
        } else if ("start".equals(drawerGravity)) {
            gravity = 0x800003;
        } else if ("end".equals(drawerGravity)) {
            gravity = 0x800005;
        }
        if (gravity > 0) {
            DrawerLayoutUtil.openDrawer(drawerLayout, gravity);
        }
    }

    private static void openDrawer(View drawerLayout, int gravity) {
        try {
            ReflectionUtils.invoke(ReflectionUtils.getMethod(drawerLayout.getClass(), "openDrawer", Integer.TYPE), drawerLayout, gravity);
        }
        catch (ReflectionUtils.ReflectionException e) {
            Bridge.getLog().error("broken", "Unable to open navigation drawer", ReflectionUtils.getCause(e), null);
        }
    }
}

