/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.ddm.DdmRegister;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.Debug;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import com.android.server.NetworkManagementSocketTagger;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    private static final String TAG = "AndroidRuntime";
    private static final boolean DEBUG = false;
    private static boolean initialized;
    private static IBinder mApplicationObject;
    private static volatile boolean mCrashing;

    private static void nativeZygoteInit() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#nativeZygoteInit()V", true, null);
    }

    private static void nativeFinishInit() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#nativeFinishInit()V", true, null);
    }

    private static void nativeSetExitWithoutCleanup(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#nativeSetExitWithoutCleanup(Z)V", true, null);
    }

    private static int Clog_e(String tag, String msg, Throwable tr) {
        return Log.printlns(4, 6, tag, msg, tr);
    }

    private static void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        TimezoneGetter.setInstance(new TimezoneGetter(){

            @Override
            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        new AndroidConfig();
        String userAgent = RuntimeInit.getDefaultUserAgent();
        System.setProperty("http.agent", userAgent);
        NetworkManagementSocketTagger.install();
        String trace = SystemProperties.get("ro.kernel.android.tracing");
        if (trace.equals("1")) {
            Slog.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    private static String getDefaultUserAgent() {
        String id2;
        String model;
        StringBuilder result = new StringBuilder(64);
        result.append("Dalvik/");
        result.append(System.getProperty("java.vm.version"));
        result.append(" (Linux; U; Android ");
        String version = Build.VERSION.RELEASE;
        result.append(version.length() > 0 ? version : "1.0");
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            result.append("; ");
            result.append(model);
        }
        if ((id2 = Build.ID).length() > 0) {
            result.append(" Build/");
            result.append(id2);
        }
        result.append(")");
        return result.toString();
    }

    private static void invokeStaticMain(String className, String[] argv, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        Method m;
        Class<?> cl;
        try {
            cl = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        throw new ZygoteInit.MethodAndArgsCaller(m, argv);
    }

    public static void main(String[] argv) {
        RuntimeInit.enableDdms();
        if (argv.length == 2 && argv[1].equals("application")) {
            RuntimeInit.redirectLogStreams();
        }
        RuntimeInit.commonInit();
        RuntimeInit.nativeFinishInit();
    }

    public static void zygoteInit(int targetSdkVersion, String[] argv, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        Trace.traceBegin(64L, "RuntimeInit");
        RuntimeInit.redirectLogStreams();
        RuntimeInit.commonInit();
        RuntimeInit.nativeZygoteInit();
        RuntimeInit.applicationInit(targetSdkVersion, argv, classLoader);
    }

    public static void wrapperInit(int targetSdkVersion, String[] argv) throws ZygoteInit.MethodAndArgsCaller {
        RuntimeInit.applicationInit(targetSdkVersion, argv, null);
    }

    private static void applicationInit(int targetSdkVersion, String[] argv, ClassLoader classLoader) throws ZygoteInit.MethodAndArgsCaller {
        Arguments args;
        RuntimeInit.nativeSetExitWithoutCleanup(true);
        VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        VMRuntime.getRuntime().setTargetSdkVersion(targetSdkVersion);
        try {
            args = new Arguments(argv);
        }
        catch (IllegalArgumentException ex) {
            Slog.e(TAG, ex.getMessage());
            return;
        }
        Trace.traceEnd(64L);
        RuntimeInit.invokeStaticMain(args.startClass, args.startArgs, classLoader);
    }

    public static void redirectLogStreams() {
        System.out.close();
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.err.close();
        System.setErr(new AndroidPrintStream(5, "System.err"));
    }

    public static void wtf(String tag, Throwable t, boolean system) {
        block3: {
            try {
                if (ActivityManagerNative.getDefault().handleApplicationWtf(mApplicationObject, tag, system, new ApplicationErrorReport.CrashInfo(t))) {
                    Process.killProcess(Process.myPid());
                    System.exit(10);
                }
            }
            catch (Throwable t2) {
                if (t2 instanceof DeadObjectException) break block3;
                Slog.e(TAG, "Error reporting WTF", t2);
                Slog.e(TAG, "Original WTF:", t);
            }
        }
    }

    public static void setApplicationObject(IBinder app) {
        mApplicationObject = app;
    }

    public static IBinder getApplicationObject() {
        return mApplicationObject;
    }

    static void enableDdms() {
        DdmRegister.registerHandlers();
    }

    static {
        mCrashing = false;
    }

    static class Arguments {
        String startClass;
        String[] startArgs;

        Arguments(String[] args) throws IllegalArgumentException {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (!arg.startsWith("--")) break;
            }
            if (curArg == args.length) {
                throw new IllegalArgumentException("Missing classname argument to RuntimeInit!");
            }
            this.startClass = args[curArg++];
            this.startArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.startArgs, 0, this.startArgs.length);
        }
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                if (mCrashing) {
                    return;
                }
                mCrashing = true;
                if (mApplicationObject == null) {
                    RuntimeInit.Clog_e(RuntimeInit.TAG, "*** FATAL EXCEPTION IN SYSTEM PROCESS: " + t.getName(), e);
                } else {
                    StringBuilder message = new StringBuilder();
                    message.append("FATAL EXCEPTION: ").append(t.getName()).append("\n");
                    String processName = ActivityThread.currentProcessName();
                    if (processName != null) {
                        message.append("Process: ").append(processName).append(", ");
                    }
                    message.append("PID: ").append(Process.myPid());
                    RuntimeInit.Clog_e(RuntimeInit.TAG, message.toString(), e);
                }
                if (ActivityThread.currentActivityThread() != null) {
                    ActivityThread.currentActivityThread().stopProfiling();
                }
                ActivityManagerNative.getDefault().handleApplicationCrash(mApplicationObject, new ApplicationErrorReport.CrashInfo(e));
            }
            catch (Throwable t2) {
                if (t2 instanceof DeadObjectException) {
                } else {
                    try {
                        RuntimeInit.Clog_e(RuntimeInit.TAG, "Error reporting crash", t2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
    }
}

