/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.AnimatedVectorDrawable_Delegate;
import android.graphics.drawable.AnimatedVectorDrawable_VectorDrawableAnimatorRT_Delegate;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.LongArray;
import android.util.PathParser;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.RenderNodeAnimatorSetHelper;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedVectorDrawable
extends Drawable
implements Animatable2 {
    private static final String LOGTAG = "AnimatedVectorDrawable";
    private static final String ANIMATED_VECTOR = "animated-vector";
    private static final String TARGET = "target";
    private static final boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private VectorDrawableAnimator mAnimatorSet = new VectorDrawableAnimatorUI(this);
    private Resources mRes;
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private AnimatorSet mAnimatorSetFromXml = null;
    private boolean mMutated;
    private ArrayList<Animatable2.AnimationCallback> mAnimationCallbacks = null;
    private Animator.AnimatorListener mAnimatorListener = null;
    private final Drawable.Callback mCallback = new Drawable.Callback(){

        @Override
        public void invalidateDrawable(Drawable who) {
            AnimatedVectorDrawable.this.invalidateSelf();
        }

        @Override
        public void scheduleDrawable(Drawable who, Runnable what, long when) {
            AnimatedVectorDrawable.this.scheduleSelf(what, when);
        }

        @Override
        public void unscheduleDrawable(Drawable who, Runnable what) {
            AnimatedVectorDrawable.this.unscheduleSelf(what);
        }
    };

    public AnimatedVectorDrawable() {
        this(null, null);
    }

    private AnimatedVectorDrawable(AnimatedVectorDrawableState state, Resources res) {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(state, this.mCallback, res);
        this.mRes = res;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimatedVectorState = new AnimatedVectorDrawableState(this.mAnimatedVectorState, this.mCallback, this.mRes);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        if (this.mAnimatedVectorState.mVectorDrawable != null) {
            this.mAnimatedVectorState.mVectorDrawable.clearMutated();
        }
        this.mMutated = false;
    }

    private static boolean shouldIgnoreInvalidAnimation() {
        Application app = ActivityThread.currentApplication();
        if (app == null || app.getApplicationInfo() == null) {
            return true;
        }
        return app.getApplicationInfo().targetSdkVersion < 24;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mAnimatedVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mAnimatedVectorState;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.getChangingConfigurations();
    }

    @Override
    public void draw(Canvas canvas) {
        this.mAnimatorSet.onDraw(canvas);
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(bounds);
    }

    @Override
    protected boolean onStateChange(int[] state) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(state);
    }

    @Override
    protected boolean onLevelChange(int level) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(level);
    }

    @Override
    public boolean onLayoutDirectionChanged(int layoutDirection) {
        return this.mAnimatedVectorState.mVectorDrawable.setLayoutDirection(layoutDirection);
    }

    @Override
    public int getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    @Override
    public void setAlpha(int alpha) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mAnimatedVectorState.mVectorDrawable.getColorFilter();
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(tint);
    }

    @Override
    public void setHotspot(float x, float y) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspot(x, y);
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspotBounds(left, top, right, bottom);
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(tintMode);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        if (this.mAnimatorSet.isInfinite() && this.mAnimatorSet.isStarted()) {
            if (visible) {
                this.mAnimatorSet.resume();
            } else {
                this.mAnimatorSet.pause();
            }
        }
        this.mAnimatedVectorState.mVectorDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    @Override
    public boolean isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    @Override
    public void getOutline(Outline outline) {
        this.mAnimatedVectorState.mVectorDrawable.getOutline(outline);
    }

    @Override
    public Insets getOpticalInsets() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpticalInsets();
    }

    @Override
    public void inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        AnimatedVectorDrawableState state = this.mAnimatedVectorState;
        int eventType = parser.getEventType();
        float pathErrorScale = 1.0f;
        while (eventType != 1) {
            if (eventType == 2) {
                TypedArray a;
                String tagName = parser.getName();
                if (ANIMATED_VECTOR.equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawable);
                    int drawableRes = a.getResourceId(0, 0);
                    if (drawableRes != 0) {
                        VectorDrawable vectorDrawable = (VectorDrawable)res.getDrawable(drawableRes, theme).mutate();
                        vectorDrawable.setAllowCaching(false);
                        vectorDrawable.setCallback(this.mCallback);
                        pathErrorScale = vectorDrawable.getPixelSize();
                        if (state.mVectorDrawable != null) {
                            state.mVectorDrawable.setCallback(null);
                        }
                        state.mVectorDrawable = vectorDrawable;
                    }
                    a.recycle();
                } else if (TARGET.equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawableTarget);
                    String target = a.getString(0);
                    int animResId = a.getResourceId(1, 0);
                    if (animResId != 0) {
                        if (theme != null) {
                            Animator objectAnimator = AnimatorInflater.loadAnimator(res, theme, animResId, pathErrorScale);
                            state.addTargetAnimator(target, objectAnimator);
                        } else {
                            state.addPendingAnimator(animResId, pathErrorScale, target);
                        }
                    }
                    a.recycle();
                }
            }
            eventType = parser.next();
        }
        this.mRes = state.mPendingAnims == null ? null : res;
    }

    public void forceAnimationOnUI() {
        if (this.mAnimatorSet instanceof VectorDrawableAnimatorRT) {
            VectorDrawableAnimatorRT animator2 = (VectorDrawableAnimatorRT)this.mAnimatorSet;
            if (animator2.isRunning()) {
                throw new UnsupportedOperationException("Cannot force Animated Vector Drawable to run on UI thread when the animation has started on RenderThread.");
            }
            this.mAnimatorSet = new VectorDrawableAnimatorUI(this);
            if (this.mAnimatorSetFromXml != null) {
                this.mAnimatorSet.init(this.mAnimatorSetFromXml);
            }
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mAnimatedVectorState != null && this.mAnimatedVectorState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawable vectorDrawable = this.mAnimatedVectorState.mVectorDrawable;
        if (vectorDrawable != null && vectorDrawable.canApplyTheme()) {
            vectorDrawable.applyTheme(t);
        }
        if (t != null) {
            this.mAnimatedVectorState.inflatePendingAnimators(t.getResources(), t);
        }
        if (this.mAnimatedVectorState.mPendingAnims == null) {
            this.mRes = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mAnimatorSet.isRunning();
    }

    public void reset() {
        this.ensureAnimatorSet();
        this.mAnimatorSet.reset();
    }

    @Override
    public void start() {
        this.ensureAnimatorSet();
        this.mAnimatorSet.start();
    }

    private void ensureAnimatorSet() {
        if (this.mAnimatorSetFromXml == null) {
            this.mAnimatorSetFromXml = new AnimatorSet();
            this.mAnimatedVectorState.prepareLocalAnimators(this.mAnimatorSetFromXml, this.mRes);
            this.mAnimatorSet.init(this.mAnimatorSetFromXml);
            this.mRes = null;
        }
    }

    @Override
    public void stop() {
        this.mAnimatorSet.end();
    }

    public void reverse() {
        this.ensureAnimatorSet();
        if (!this.canReverse()) {
            Log.w(LOGTAG, "AnimatedVectorDrawable can't reverse()");
            return;
        }
        this.mAnimatorSet.reverse();
    }

    public boolean canReverse() {
        return this.mAnimatorSet.canReverse();
    }

    @Override
    public void registerAnimationCallback(Animatable2.AnimationCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
        }
        this.mAnimationCallbacks.add(callback);
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    ArrayList tmpCallbacks = new ArrayList(AnimatedVectorDrawable.this.mAnimationCallbacks);
                    int size = tmpCallbacks.size();
                    for (int i = 0; i < size; ++i) {
                        ((Animatable2.AnimationCallback)tmpCallbacks.get(i)).onAnimationStart(AnimatedVectorDrawable.this);
                    }
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    ArrayList tmpCallbacks = new ArrayList(AnimatedVectorDrawable.this.mAnimationCallbacks);
                    int size = tmpCallbacks.size();
                    for (int i = 0; i < size; ++i) {
                        ((Animatable2.AnimationCallback)tmpCallbacks.get(i)).onAnimationEnd(AnimatedVectorDrawable.this);
                    }
                }
            };
        }
        this.mAnimatorSet.setListener(this.mAnimatorListener);
    }

    private void removeAnimatorSetListener() {
        if (this.mAnimatorListener != null) {
            this.mAnimatorSet.removeListener(this.mAnimatorListener);
            this.mAnimatorListener = null;
        }
    }

    @Override
    public boolean unregisterAnimationCallback(Animatable2.AnimationCallback callback) {
        if (this.mAnimationCallbacks == null || callback == null) {
            return false;
        }
        boolean removed = this.mAnimationCallbacks.remove(callback);
        if (this.mAnimationCallbacks.size() == 0) {
            this.removeAnimatorSetListener();
        }
        return removed;
    }

    @Override
    public void clearAnimationCallbacks() {
        this.removeAnimatorSetListener();
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.mAnimationCallbacks.clear();
    }

    @LayoutlibDelegate
    private static long nCreateAnimatorSet() {
        return AnimatedVectorDrawable_Delegate.nCreateAnimatorSet();
    }

    @LayoutlibDelegate
    private static void nAddAnimator(long l, long l2, long l3, long l4, long l5, int n) {
        AnimatedVectorDrawable_Delegate.nAddAnimator(l, l2, l3, l4, l5, n);
    }

    @LayoutlibDelegate
    private static long nCreateGroupPropertyHolder(long l, int n, float f, float f2) {
        return AnimatedVectorDrawable_Delegate.nCreateGroupPropertyHolder(l, n, f, f2);
    }

    @LayoutlibDelegate
    private static long nCreatePathDataPropertyHolder(long l, long l2, long l3) {
        return AnimatedVectorDrawable_Delegate.nCreatePathDataPropertyHolder(l, l2, l3);
    }

    @LayoutlibDelegate
    private static long nCreatePathColorPropertyHolder(long l, int n, int n2, int n3) {
        return AnimatedVectorDrawable_Delegate.nCreatePathColorPropertyHolder(l, n, n2, n3);
    }

    @LayoutlibDelegate
    private static long nCreatePathPropertyHolder(long l, int n, float f, float f2) {
        return AnimatedVectorDrawable_Delegate.nCreatePathPropertyHolder(l, n, f, f2);
    }

    @LayoutlibDelegate
    private static long nCreateRootAlphaPropertyHolder(long l, float f, float f2) {
        return AnimatedVectorDrawable_Delegate.nCreateRootAlphaPropertyHolder(l, f, f2);
    }

    @LayoutlibDelegate
    private static void nSetPropertyHolderData(long l, float[] fArray, int n) {
        AnimatedVectorDrawable_Delegate.nSetPropertyHolderData(l, fArray, n);
    }

    @LayoutlibDelegate
    private static void nStart(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
        AnimatedVectorDrawable_Delegate.nStart(l, vectorDrawableAnimatorRT, n);
    }

    @LayoutlibDelegate
    private static void nReverse(long l, VectorDrawableAnimatorRT vectorDrawableAnimatorRT, int n) {
        AnimatedVectorDrawable_Delegate.nReverse(l, vectorDrawableAnimatorRT, n);
    }

    @LayoutlibDelegate
    private static void nEnd(long l) {
        AnimatedVectorDrawable_Delegate.nEnd(l);
    }

    @LayoutlibDelegate
    private static void nReset(long l) {
        AnimatedVectorDrawable_Delegate.nReset(l);
    }

    public static class VectorDrawableAnimatorRT
    implements VectorDrawableAnimator {
        private static final int START_ANIMATION = 1;
        private static final int REVERSE_ANIMATION = 2;
        private static final int RESET_ANIMATION = 3;
        private static final int END_ANIMATION = 4;
        private Animator.AnimatorListener mListener = null;
        private final LongArray mStartDelays = new LongArray();
        private PropertyValuesHolder.PropertyValues mTmpValues = new PropertyValuesHolder.PropertyValues();
        private long mSetPtr = 0L;
        private boolean mContainsSequentialAnimators = false;
        private boolean mStarted = false;
        private boolean mInitialized = false;
        private boolean mIsReversible = false;
        private boolean mIsInfinite = false;
        private boolean mShouldIgnoreInvalidAnim;
        private final VirtualRefBasePtr mSetRefBasePtr;
        private WeakReference<RenderNode> mLastSeenTarget = null;
        private int mLastListenerId = 0;
        private final IntArray mPendingAnimationActions = new IntArray();
        private final Drawable mDrawable;

        VectorDrawableAnimatorRT(AnimatedVectorDrawable drawable2) {
            this.mDrawable = drawable2;
            this.mSetPtr = AnimatedVectorDrawable.nCreateAnimatorSet();
            this.mSetRefBasePtr = new VirtualRefBasePtr(this.mSetPtr);
        }

        @Override
        public void init(AnimatorSet set) {
            if (this.mInitialized) {
                throw new UnsupportedOperationException("VectorDrawableAnimator cannot be re-initialized");
            }
            this.mShouldIgnoreInvalidAnim = AnimatedVectorDrawable.shouldIgnoreInvalidAnimation();
            this.parseAnimatorSet(set, 0L);
            this.mInitialized = true;
            this.mIsInfinite = set.getTotalDuration() == -1L;
            this.mIsReversible = true;
            if (this.mContainsSequentialAnimators) {
                this.mIsReversible = false;
            } else {
                for (int i = 0; i < this.mStartDelays.size(); ++i) {
                    if (this.mStartDelays.get(i) <= 0L) continue;
                    this.mIsReversible = false;
                    return;
                }
            }
        }

        private void parseAnimatorSet(AnimatorSet set, long startTime) {
            ArrayList<Animator> animators = set.getChildAnimations();
            boolean playTogether = set.shouldPlayTogether();
            for (int i = 0; i < animators.size(); ++i) {
                Animator animator2 = animators.get(i);
                if (animator2 instanceof AnimatorSet) {
                    this.parseAnimatorSet((AnimatorSet)animator2, startTime);
                } else if (animator2 instanceof ObjectAnimator) {
                    this.createRTAnimator((ObjectAnimator)animator2, startTime);
                }
                if (playTogether) continue;
                startTime += animator2.getTotalDuration();
                this.mContainsSequentialAnimators = true;
            }
        }

        private void createRTAnimator(ObjectAnimator animator2, long startTime) {
            PropertyValuesHolder[] values = animator2.getValues();
            Object target = animator2.getTarget();
            if (target instanceof VectorDrawable.VGroup) {
                this.createRTAnimatorForGroup(values, animator2, (VectorDrawable.VGroup)target, startTime);
            } else if (target instanceof VectorDrawable.VPath) {
                for (int i = 0; i < values.length; ++i) {
                    values[i].getPropertyValues(this.mTmpValues);
                    if (this.mTmpValues.endValue instanceof PathParser.PathData && this.mTmpValues.propertyName.equals("pathData")) {
                        this.createRTAnimatorForPath(animator2, (VectorDrawable.VPath)target, startTime);
                        continue;
                    }
                    if (target instanceof VectorDrawable.VFullPath) {
                        this.createRTAnimatorForFullPath(animator2, (VectorDrawable.VFullPath)target, startTime);
                        continue;
                    }
                    if (this.mShouldIgnoreInvalidAnim) continue;
                    throw new IllegalArgumentException("ClipPath only supports PathData property");
                }
            } else if (target instanceof VectorDrawable.VectorDrawableState) {
                this.createRTAnimatorForRootGroup(values, animator2, (VectorDrawable.VectorDrawableState)target, startTime);
            } else if (!this.mShouldIgnoreInvalidAnim) {
                throw new UnsupportedOperationException("Target should be either VGroup, VPath, or ConstantState, " + target == null ? "Null target" : target.getClass() + " is not supported");
            }
        }

        private void createRTAnimatorForGroup(PropertyValuesHolder[] values, ObjectAnimator animator2, VectorDrawable.VGroup target, long startTime) {
            long nativePtr = target.getNativePtr();
            for (int i = 0; i < values.length; ++i) {
                values[i].getPropertyValues(this.mTmpValues);
                int propertyId = VectorDrawable.VGroup.getPropertyIndex(this.mTmpValues.propertyName);
                if (this.mTmpValues.type != Float.class && this.mTmpValues.type != Float.TYPE || propertyId < 0) continue;
                long propertyPtr = AnimatedVectorDrawable.nCreateGroupPropertyHolder(nativePtr, propertyId, ((Float)this.mTmpValues.startValue).floatValue(), ((Float)this.mTmpValues.endValue).floatValue());
                if (this.mTmpValues.dataSource != null) {
                    float[] dataPoints = VectorDrawableAnimatorRT.createDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                    AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
                }
                this.createNativeChildAnimator(propertyPtr, startTime, animator2);
            }
        }

        private void createRTAnimatorForPath(ObjectAnimator animator2, VectorDrawable.VPath target, long startTime) {
            long nativePtr = target.getNativePtr();
            long startPathDataPtr = ((PathParser.PathData)this.mTmpValues.startValue).getNativePtr();
            long endPathDataPtr = ((PathParser.PathData)this.mTmpValues.endValue).getNativePtr();
            long propertyPtr = AnimatedVectorDrawable.nCreatePathDataPropertyHolder(nativePtr, startPathDataPtr, endPathDataPtr);
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private void createRTAnimatorForFullPath(ObjectAnimator animator2, VectorDrawable.VFullPath target, long startTime) {
            long propertyPtr;
            int propertyId = target.getPropertyIndex(this.mTmpValues.propertyName);
            long nativePtr = target.getNativePtr();
            if (this.mTmpValues.type == Float.class || this.mTmpValues.type == Float.TYPE) {
                if (propertyId < 0) {
                    if (this.mShouldIgnoreInvalidAnim) {
                        return;
                    }
                    throw new IllegalArgumentException("Property: " + this.mTmpValues.propertyName + " is not supported for FullPath");
                }
                propertyPtr = AnimatedVectorDrawable.nCreatePathPropertyHolder(nativePtr, propertyId, ((Float)this.mTmpValues.startValue).floatValue(), ((Float)this.mTmpValues.endValue).floatValue());
            } else if (this.mTmpValues.type == Integer.class || this.mTmpValues.type == Integer.TYPE) {
                propertyPtr = AnimatedVectorDrawable.nCreatePathColorPropertyHolder(nativePtr, propertyId, (Integer)this.mTmpValues.startValue, (Integer)this.mTmpValues.endValue);
            } else {
                if (this.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("Unsupported type: " + this.mTmpValues.type + ". Only float, int or PathData value is " + "supported for Paths.");
            }
            if (this.mTmpValues.dataSource != null) {
                float[] dataPoints = VectorDrawableAnimatorRT.createDataPoints(this.mTmpValues.dataSource, animator2.getDuration());
                AnimatedVectorDrawable.nSetPropertyHolderData(propertyPtr, dataPoints, dataPoints.length);
            }
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private void createRTAnimatorForRootGroup(PropertyValuesHolder[] values, ObjectAnimator animator2, VectorDrawable.VectorDrawableState target, long startTime) {
            long nativePtr = target.getNativeRenderer();
            if (!animator2.getPropertyName().equals("alpha")) {
                if (this.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("Only alpha is supported for root group");
            }
            Float startValue = null;
            Float endValue = null;
            for (int i = 0; i < values.length; ++i) {
                values[i].getPropertyValues(this.mTmpValues);
                if (!this.mTmpValues.propertyName.equals("alpha")) continue;
                startValue = (Float)this.mTmpValues.startValue;
                endValue = (Float)this.mTmpValues.endValue;
                break;
            }
            if (startValue == null && endValue == null) {
                if (this.mShouldIgnoreInvalidAnim) {
                    return;
                }
                throw new UnsupportedOperationException("No alpha values are specified");
            }
            long propertyPtr = AnimatedVectorDrawable.nCreateRootAlphaPropertyHolder(nativePtr, startValue.floatValue(), endValue.floatValue());
            this.createNativeChildAnimator(propertyPtr, startTime, animator2);
        }

        private static float[] createDataPoints(PropertyValuesHolder.PropertyValues.DataSource dataSource, long duration) {
            long frameIntervalNanos = Choreographer.getInstance().getFrameIntervalNanos();
            int animIntervalMs = (int)(frameIntervalNanos / 1000000L);
            int numAnimFrames = (int)Math.ceil((double)duration / (double)animIntervalMs);
            float[] values = new float[numAnimFrames];
            float lastFrame = numAnimFrames - 1;
            for (int i = 0; i < numAnimFrames; ++i) {
                float fraction2 = (float)i / lastFrame;
                values[i] = ((Float)dataSource.getValueAtFraction(fraction2)).floatValue();
            }
            return values;
        }

        private void createNativeChildAnimator(long propertyPtr, long extraDelay, ObjectAnimator animator2) {
            long duration = animator2.getDuration();
            int repeatCount = animator2.getRepeatCount();
            long startDelay = extraDelay + animator2.getStartDelay();
            TimeInterpolator interpolator2 = animator2.getInterpolator();
            long nativeInterpolator = RenderNodeAnimatorSetHelper.createNativeInterpolator(interpolator2, duration);
            startDelay = (long)((float)startDelay * ValueAnimator.getDurationScale());
            duration = (long)((float)duration * ValueAnimator.getDurationScale());
            this.mStartDelays.add(startDelay);
            AnimatedVectorDrawable.nAddAnimator(this.mSetPtr, propertyPtr, nativeInterpolator, startDelay, duration, repeatCount);
        }

        protected void recordLastSeenTarget(DisplayListCanvas canvas) {
            this.mLastSeenTarget = new WeakReference<RenderNode>(RenderNodeAnimatorSetHelper.getTarget(canvas));
            if (this.mPendingAnimationActions.size() > 0 && this.useLastSeenTarget()) {
                for (int i = 0; i < this.mPendingAnimationActions.size(); ++i) {
                    this.handlePendingAction(this.mPendingAnimationActions.get(i));
                }
                this.mPendingAnimationActions.clear();
            }
        }

        private void handlePendingAction(int pendingAnimationAction) {
            if (pendingAnimationAction == 1) {
                this.startAnimation();
            } else if (pendingAnimationAction == 2) {
                this.reverseAnimation();
            } else if (pendingAnimationAction == 3) {
                this.resetAnimation();
            } else if (pendingAnimationAction == 4) {
                this.endAnimation();
            } else {
                throw new UnsupportedOperationException("Animation action " + pendingAnimationAction + "is not supported");
            }
        }

        boolean useLastSeenTarget_Original() {
            RenderNode target;
            if (this.mLastSeenTarget != null && (target = (RenderNode)this.mLastSeenTarget.get()) != null && target.isAttached()) {
                target.addAnimator(this);
                return true;
            }
            return false;
        }

        @LayoutlibDelegate
        private boolean useLastSeenTarget() {
            return AnimatedVectorDrawable_VectorDrawableAnimatorRT_Delegate.useLastSeenTarget(this);
        }

        private void invalidateOwningView() {
            this.mDrawable.invalidateSelf();
        }

        private void addPendingAction(int pendingAnimationAction) {
            this.invalidateOwningView();
            this.mPendingAnimationActions.add(pendingAnimationAction);
        }

        @Override
        public void start() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.startAnimation();
            } else {
                this.addPendingAction(1);
            }
        }

        @Override
        public void end() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.endAnimation();
            } else {
                this.addPendingAction(4);
            }
        }

        @Override
        public void reset() {
            if (!this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.resetAnimation();
            } else {
                this.addPendingAction(3);
            }
        }

        @Override
        public void reverse() {
            if (!this.mIsReversible || !this.mInitialized) {
                return;
            }
            if (this.useLastSeenTarget()) {
                this.reverseAnimation();
            } else {
                this.addPendingAction(2);
            }
        }

        private void startAnimation() {
            this.mStarted = true;
            AnimatedVectorDrawable.nStart(this.mSetPtr, this, ++this.mLastListenerId);
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationStart(null);
            }
        }

        private void endAnimation() {
            AnimatedVectorDrawable.nEnd(this.mSetPtr);
            this.invalidateOwningView();
        }

        private void resetAnimation() {
            AnimatedVectorDrawable.nReset(this.mSetPtr);
            this.invalidateOwningView();
        }

        private void reverseAnimation() {
            this.mStarted = true;
            AnimatedVectorDrawable.nReverse(this.mSetPtr, this, ++this.mLastListenerId);
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationStart(null);
            }
        }

        public long getAnimatorNativePtr() {
            return this.mSetPtr;
        }

        @Override
        public boolean canReverse() {
            return this.mIsReversible;
        }

        @Override
        public boolean isStarted() {
            return this.mStarted;
        }

        @Override
        public boolean isRunning() {
            if (!this.mInitialized) {
                return false;
            }
            return this.mStarted;
        }

        @Override
        public void setListener(Animator.AnimatorListener listener) {
            this.mListener = listener;
        }

        @Override
        public void removeListener(Animator.AnimatorListener listener) {
            this.mListener = null;
        }

        @Override
        public void onDraw(Canvas canvas) {
            if (canvas.isHardwareAccelerated()) {
                this.recordLastSeenTarget((DisplayListCanvas)canvas);
            }
        }

        @Override
        public boolean isInfinite() {
            return this.mIsInfinite;
        }

        @Override
        public void pause() {
        }

        @Override
        public void resume() {
        }

        private void onAnimationEnd(int listenerId) {
            if (listenerId != this.mLastListenerId) {
                return;
            }
            this.mStarted = false;
            this.invalidateOwningView();
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(null);
            }
        }

        private static void callOnFinished(VectorDrawableAnimatorRT set, int id2) {
            set.onAnimationEnd(id2);
        }
    }

    private static class VectorDrawableAnimatorUI
    implements VectorDrawableAnimator {
        private AnimatorSet mSet = null;
        private final Drawable mDrawable;
        private ArrayList<Animator.AnimatorListener> mListenerArray = null;
        private boolean mIsInfinite = false;

        VectorDrawableAnimatorUI(AnimatedVectorDrawable drawable2) {
            this.mDrawable = drawable2;
        }

        @Override
        public void init(AnimatorSet set) {
            if (this.mSet != null) {
                throw new UnsupportedOperationException("VectorDrawableAnimator cannot be re-initialized");
            }
            this.mSet = set.clone();
            boolean bl = this.mIsInfinite = this.mSet.getTotalDuration() == -1L;
            if (this.mListenerArray != null && !this.mListenerArray.isEmpty()) {
                for (int i = 0; i < this.mListenerArray.size(); ++i) {
                    this.mSet.addListener(this.mListenerArray.get(i));
                }
                this.mListenerArray.clear();
                this.mListenerArray = null;
            }
        }

        @Override
        public void start() {
            if (this.mSet == null || this.mSet.isStarted()) {
                return;
            }
            this.mSet.start();
            this.invalidateOwningView();
        }

        @Override
        public void end() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.end();
        }

        @Override
        public void reset() {
            if (this.mSet == null) {
                return;
            }
            this.start();
            this.mSet.cancel();
        }

        @Override
        public void reverse() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.reverse();
            this.invalidateOwningView();
        }

        @Override
        public boolean canReverse() {
            return this.mSet != null && this.mSet.canReverse();
        }

        @Override
        public void setListener(Animator.AnimatorListener listener) {
            if (this.mSet == null) {
                if (this.mListenerArray == null) {
                    this.mListenerArray = new ArrayList();
                }
                this.mListenerArray.add(listener);
            } else {
                this.mSet.addListener(listener);
            }
        }

        @Override
        public void removeListener(Animator.AnimatorListener listener) {
            if (this.mSet == null) {
                if (this.mListenerArray == null) {
                    return;
                }
                this.mListenerArray.remove(listener);
            } else {
                this.mSet.removeListener(listener);
            }
        }

        @Override
        public void onDraw(Canvas canvas) {
            if (this.mSet != null && this.mSet.isStarted()) {
                this.invalidateOwningView();
            }
        }

        @Override
        public boolean isStarted() {
            return this.mSet != null && this.mSet.isStarted();
        }

        @Override
        public boolean isRunning() {
            return this.mSet != null && this.mSet.isRunning();
        }

        @Override
        public boolean isInfinite() {
            return this.mIsInfinite;
        }

        @Override
        public void pause() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.pause();
        }

        @Override
        public void resume() {
            if (this.mSet == null) {
                return;
            }
            this.mSet.resume();
        }

        private void invalidateOwningView() {
            this.mDrawable.invalidateSelf();
        }
    }

    private static interface VectorDrawableAnimator {
        public void init(AnimatorSet var1);

        public void start();

        public void end();

        public void reset();

        public void reverse();

        public boolean canReverse();

        public void setListener(Animator.AnimatorListener var1);

        public void removeListener(Animator.AnimatorListener var1);

        public void onDraw(Canvas var1);

        public boolean isStarted();

        public boolean isRunning();

        public boolean isInfinite();

        public void pause();

        public void resume();
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        VectorDrawable mVectorDrawable;
        ArrayList<PendingAnimator> mPendingAnims;
        ArrayList<Animator> mAnimators;
        ArrayMap<Animator, String> mTargetNameMap;

        public AnimatedVectorDrawableState(AnimatedVectorDrawableState copy, Drawable.Callback owner, Resources res) {
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                if (copy.mVectorDrawable != null) {
                    Drawable.ConstantState cs = copy.mVectorDrawable.getConstantState();
                    this.mVectorDrawable = res != null ? (VectorDrawable)cs.newDrawable(res) : (VectorDrawable)cs.newDrawable();
                    this.mVectorDrawable = (VectorDrawable)this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setCallback(owner);
                    this.mVectorDrawable.setLayoutDirection(copy.mVectorDrawable.getLayoutDirection());
                    this.mVectorDrawable.setBounds(copy.mVectorDrawable.getBounds());
                    this.mVectorDrawable.setAllowCaching(false);
                }
                if (copy.mAnimators != null) {
                    this.mAnimators = new ArrayList<Animator>(copy.mAnimators);
                }
                if (copy.mTargetNameMap != null) {
                    this.mTargetNameMap = new ArrayMap<Animator, String>(copy.mTargetNameMap);
                }
                if (copy.mPendingAnims != null) {
                    this.mPendingAnims = new ArrayList<PendingAnimator>(copy.mPendingAnims);
                }
            } else {
                this.mVectorDrawable = new VectorDrawable();
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mVectorDrawable != null && this.mVectorDrawable.canApplyTheme() || this.mPendingAnims != null || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedVectorDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimatedVectorDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public void addPendingAnimator(int resId, float pathErrorScale, String target) {
            if (this.mPendingAnims == null) {
                this.mPendingAnims = new ArrayList(1);
            }
            this.mPendingAnims.add(new PendingAnimator(resId, pathErrorScale, target));
        }

        public void addTargetAnimator(String targetName, Animator animator2) {
            if (this.mAnimators == null) {
                this.mAnimators = new ArrayList(1);
                this.mTargetNameMap = new ArrayMap(1);
            }
            this.mAnimators.add(animator2);
            this.mTargetNameMap.put(animator2, targetName);
        }

        public void prepareLocalAnimators(AnimatorSet animatorSet, Resources res) {
            int count;
            if (this.mPendingAnims != null) {
                if (res != null) {
                    this.inflatePendingAnimators(res, null);
                } else {
                    Log.e(AnimatedVectorDrawable.LOGTAG, "Failed to load animators. Either the AnimatedVectorDrawable must be created using a Resources object or applyTheme() must be called with a non-null Theme object.");
                }
                this.mPendingAnims = null;
            }
            int n = count = this.mAnimators == null ? 0 : this.mAnimators.size();
            if (count > 0) {
                Animator firstAnim = this.prepareLocalAnimator(0);
                AnimatorSet.Builder builder = animatorSet.play(firstAnim);
                for (int i = 1; i < count; ++i) {
                    Animator nextAnim = this.prepareLocalAnimator(i);
                    builder.with(nextAnim);
                }
            }
        }

        private Animator prepareLocalAnimator(int index) {
            Animator animator2 = this.mAnimators.get(index);
            Animator localAnimator = animator2.clone();
            String targetName = this.mTargetNameMap.get(animator2);
            Object target = this.mVectorDrawable.getTargetByName(targetName);
            localAnimator.setTarget(target);
            return localAnimator;
        }

        public void inflatePendingAnimators(Resources res, Resources.Theme t) {
            ArrayList<PendingAnimator> pendingAnims = this.mPendingAnims;
            if (pendingAnims != null) {
                this.mPendingAnims = null;
                int count = pendingAnims.size();
                for (int i = 0; i < count; ++i) {
                    PendingAnimator pendingAnimator = pendingAnims.get(i);
                    Animator objectAnimator = pendingAnimator.newInstance(res, t);
                    this.addTargetAnimator(pendingAnimator.target, objectAnimator);
                }
            }
        }

        private static class PendingAnimator {
            public final int animResId;
            public final float pathErrorScale;
            public final String target;

            public PendingAnimator(int animResId, float pathErrorScale, String target) {
                this.animResId = animResId;
                this.pathErrorScale = pathErrorScale;
                this.target = target;
            }

            public Animator newInstance(Resources res, Resources.Theme theme) {
                return AnimatorInflater.loadAnimator(res, theme, this.animResId, this.pathErrorScale);
            }
        }
    }
}

