/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import java.awt.Paint;

public abstract class Gradient_Delegate
extends Shader_Delegate {
    protected final int[] mColors;
    protected final float[] mPositions;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getSupportMessage() {
        return null;
    }

    protected Gradient_Delegate(int[] colors, float[] positions) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        if (positions == null) {
            float spacing = 1.0f / (float)(colors.length - 1);
            positions = new float[colors.length];
            positions[0] = 0.0f;
            positions[colors.length - 1] = 1.0f;
            for (int i = 1; i < colors.length - 1; ++i) {
                positions[i] = spacing * (float)i;
            }
        }
        this.mColors = colors;
        this.mPositions = positions;
    }

    protected static abstract class GradientPaint
    implements Paint {
        private static final int GRADIENT_SIZE = 100;
        private final int[] mColors;
        private final float[] mPositions;
        private final Shader.TileMode mTileMode;
        private int[] mGradient;

        protected GradientPaint(int[] colors, float[] positions, Shader.TileMode tileMode) {
            this.mColors = colors;
            this.mPositions = positions;
            this.mTileMode = tileMode;
        }

        @Override
        public int getTransparency() {
            return 3;
        }

        protected void precomputeGradientColors() {
            if (this.mGradient == null) {
                this.mGradient = new int[101];
                int prevPos = 0;
                int nextPos = 1;
                for (int i = 0; i <= 100; ++i) {
                    float currentPos = (float)i / 100.0f;
                    while (currentPos > this.mPositions[nextPos]) {
                        prevPos = nextPos++;
                    }
                    float percent = (currentPos - this.mPositions[prevPos]) / (this.mPositions[nextPos] - this.mPositions[prevPos]);
                    this.mGradient[i] = this.computeColor(this.mColors[prevPos], this.mColors[nextPos], percent);
                }
            }
        }

        protected int getGradientColor(float pos) {
            int intPart;
            if (pos < 0.0f) {
                if (this.mTileMode != null) {
                    switch (this.mTileMode) {
                        case CLAMP: {
                            pos = 0.0f;
                            break;
                        }
                        case REPEAT: {
                            pos -= (float)Math.floor(pos);
                            break;
                        }
                        case MIRROR: {
                            pos = Math.abs(pos);
                            intPart = (int)Math.floor(pos);
                            pos -= (float)intPart;
                            if (intPart % 2 != 1) break;
                            pos = 1.0f - pos;
                        }
                    }
                } else {
                    pos = 0.0f;
                }
            } else if (pos > 1.0f) {
                if (this.mTileMode != null) {
                    switch (this.mTileMode) {
                        case CLAMP: {
                            pos = 1.0f;
                            break;
                        }
                        case REPEAT: {
                            pos -= (float)Math.floor(pos);
                            break;
                        }
                        case MIRROR: {
                            intPart = (int)Math.floor(pos);
                            pos -= (float)intPart;
                            if (intPart % 2 != 1) break;
                            pos = 1.0f - pos;
                        }
                    }
                } else {
                    pos = 1.0f;
                }
            }
            int index = (int)((double)(pos * 100.0f) + 0.5);
            return this.mGradient[index];
        }

        private int computeColor(int c1, int c2, float percent) {
            int a = this.computeChannel(c1 >> 24 & 0xFF, c2 >> 24 & 0xFF, percent);
            int r = this.computeChannel(c1 >> 16 & 0xFF, c2 >> 16 & 0xFF, percent);
            int g = this.computeChannel(c1 >> 8 & 0xFF, c2 >> 8 & 0xFF, percent);
            int b = this.computeChannel(c1 & 0xFF, c2 & 0xFF, percent);
            return a << 24 | r << 16 | g << 8 | b;
        }

        private int computeChannel(int c1, int c2, float percent) {
            return c1 + (int)((double)(percent * (float)(c2 - c1)) + 0.5);
        }
    }
}

